/*
 * Decompiled with CFR 0.152.
 */
package demetra.datatypes.sa;

import demetra.datatypes.sa.SaItemType;
import demetra.datatypes.sa.SaManager;
import ec.satoolkit.ISaSpecification;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.utilities.NameManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaProcessingType
implements InformationSetSerializable {
    public static final String METADATA = "metadata";
    public static final String DOMAIN_SPECS = "domainspecs";
    public static final String TIMESTAMP = "TimeStamp";
    public static final String OWNER = "Owner";
    private final Map<String, String> metaData = new HashMap<String, String>();
    private final List<SaItemType> items = new ArrayList<SaItemType>();

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (!this.metaData.isEmpty()) {
            InformationSet mset = new InformationSet();
            for (Map.Entry<String, String> entry : this.metaData.entrySet()) {
                if (((String)entry.getValue()).isEmpty()) continue;
                mset.set((String)entry.getKey(), entry.getValue());
            }
            info.set(METADATA, (Object)mset);
        }
        NameManager dic = new NameManager(ISaSpecification.class, "spec", null);
        int idx = 1;
        for (SaItemType item : this.items) {
            item.write(info.subSet("sa" + idx++), (NameManager<ISaSpecification>)dic, verbose);
        }
        InformationSet defspec = info.subSet(DOMAIN_SPECS);
        for (String key : dic.getNames()) {
            defspec.set(key, (Object)((ISaSpecification)dic.get(key)).write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet defspec;
        InformationSet mset = info.getSubSet(METADATA);
        if (mset != null) {
            List sel = mset.deepSelect(String.class);
            for (Information sinfo : sel) {
                this.metaData.put(sinfo.name, (String)sinfo.value);
            }
        }
        if ((defspec = info.getSubSet(DOMAIN_SPECS)) == null) {
            return false;
        }
        NameManager dic = new NameManager(ISaSpecification.class, "spec", null);
        List dspecs = defspec.select(InformationSet.class);
        HashMap<String, String> equivalence = new HashMap<String, String>();
        for (Information dspec : dspecs) {
            ISaSpecification cur = SaManager.createSpecification((InformationSet)dspec.value);
            if (cur == null) continue;
            String cname = dic.get((Object)cur);
            if (cname != null) {
                equivalence.put(dspec.name, cname);
                continue;
            }
            dic.set(dspec.name, (Object)cur);
        }
        List sas = info.select("sa*", InformationSet.class);
        for (Information sa : sas) {
            SaItemType cur = SaItemType.read((InformationSet)sa.value, (NameManager<ISaSpecification>)dic, equivalence);
            if (cur == null) continue;
            this.items.add(cur);
        }
        return true;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public List<SaItemType> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaProcessingType)) {
            return false;
        }
        SaProcessingType other = (SaProcessingType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        List<SaItemType> this$items = this.getItems();
        List<SaItemType> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaProcessingType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        List<SaItemType> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "SaProcessingType(metaData=" + this.getMetaData() + ", items=" + this.getItems() + ")";
    }
}

