/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IDataNormalizer;
import ec.tstoolkit.data.IReadDataBlock;

public class RootMeanSquareNormalizer
implements IDataNormalizer {
    private double m_c;
    private double[] m_data;

    public static double hypot(double a, double b) {
        if (Math.abs(a) > Math.abs(b)) {
            double r = b / a;
            return Math.abs(a) * Math.sqrt(1.0 + r * r);
        }
        if (b != 0.0) {
            double r = a / b;
            return Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return 0.0;
    }

    @Override
    public double getFactor() {
        return this.m_c;
    }

    @Override
    public double[] getNormalizedData() {
        return this.m_data;
    }

    private boolean process() {
        int i;
        double s = 0.0;
        double n = 0.0;
        for (i = 0; i < this.m_data.length; ++i) {
            double d = this.m_data[i];
            if (!Double.isFinite(d)) continue;
            s = RootMeanSquareNormalizer.hypot(s, d);
            n += 1.0;
        }
        if (s == 0.0) {
            return false;
        }
        this.m_c = Math.sqrt(n) / s;
        for (i = 0; i < this.m_data.length; ++i) {
            if (!Double.isFinite(this.m_data[i])) continue;
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] * this.m_c;
        }
        return true;
    }

    public boolean process(double[] data) {
        this.m_c = 1.0;
        this.m_data = (double[])data.clone();
        return this.process();
    }

    @Override
    public boolean process(IReadDataBlock data) {
        this.m_c = 1.0;
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        return this.process();
    }
}

