/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.IQrDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class ThinHouseholder
extends AbstractLinearSystemSolver
implements IQrDecomposition {
    private double[] m_qr = null;
    private double[] m_beta = null;
    private int m_n = 0;
    private int m_m = 0;

    @Override
    public void decompose(Matrix m) {
        this.init(m, true);
        this.householder();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m), false);
        this.householder();
    }

    @Override
    public boolean isFullRank() {
        if (this.m_beta == null) {
            return false;
        }
        for (int j = 0; j < this.m_n; ++j) {
            if (!(Math.abs(this.m_beta[j]) <= this.getEpsilon())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEquationsCount() {
        return this.m_m;
    }

    @Override
    public int getUnknownsCount() {
        return this.m_n;
    }

    @Override
    public Matrix getR() {
        Matrix r = new Matrix(this.m_n, this.m_n);
        double[] data = r.internalStorage();
        int i = 0;
        int k = 0;
        int l = 0;
        while (i < this.m_n) {
            for (int j = 0; j <= i; ++j) {
                data[k + j] = this.m_qr[l + j];
            }
            ++i;
            l += this.m_m;
            k += this.m_n;
        }
        return r;
    }

    @Override
    public DataBlock getRDiagonal() {
        int inc = this.m_m + 1;
        return new DataBlock(this.m_qr, 0, inc * this.m_n, inc);
    }

    @Override
    public void leastSquares(IReadDataBlock x, IDataBlock b, IDataBlock res) {
        if (x.getLength() != this.m_m) {
            throw new MatrixException("Incompatible dimensions");
        }
        if (!this.isFullRank()) {
            throw new MatrixException("Matrix is rank deficient.");
        }
        double[] y = new double[x.getLength()];
        x.copyTo(y, 0);
        this.QtB(y);
        if (res != null) {
            res.copyFrom(y, this.m_n);
        }
        int k = this.m_n - 1;
        int km = k * this.m_m;
        while (k >= 0) {
            int n = k;
            y[n] = y[n] / this.m_qr[k + km];
            for (int i = 0; i < k; ++i) {
                int n2 = i;
                y[n2] = y[n2] - y[k] * this.m_qr[i + km];
            }
            --k;
            km -= this.m_m;
        }
        b.copyFrom(y, 0);
    }

    @Override
    public void solve(DataBlock xin, DataBlock xout) {
        this.leastSquares(xin, xout, null);
    }

    private void init(Matrix m, boolean clone) {
        this.m_m = m.getRowsCount();
        this.m_n = m.getColumnsCount();
        if (this.m_m < this.m_n) {
            throw new MatrixException("Incompatible dimensions");
        }
        this.m_qr = clone ? (double[])m.data_.clone() : m.data_;
        this.m_beta = new double[this.m_n];
    }

    private void householder() {
        int k = 0;
        int km = 0;
        while (k < this.m_n) {
            double sigma = 0.0;
            double x1 = this.m_qr[k + km];
            for (int i = k + 1; i < this.m_m; ++i) {
                double tmp = this.m_qr[i + km];
                sigma += tmp * tmp;
            }
            if (sigma > this.getEpsilon()) {
                double nrm = Math.sqrt(sigma + x1 * x1);
                double v1 = x1 <= 0.0 ? x1 - nrm : -sigma / (x1 + nrm);
                this.m_beta[k] = 2.0 * v1 * v1 / (sigma + v1 * v1);
                for (int i = k + 1; i < this.m_m; ++i) {
                    int n = i + km;
                    this.m_qr[n] = this.m_qr[n] / v1;
                }
                this.m_qr[k + km] = nrm;
                int j = k + 1;
                int jm = (k + 1) * this.m_m;
                while (j < this.m_n) {
                    int i;
                    double s = this.m_qr[k + jm];
                    for (i = k + 1; i < this.m_m; ++i) {
                        s += this.m_qr[i + km] * this.m_qr[i + jm];
                    }
                    int n = k + jm;
                    this.m_qr[n] = this.m_qr[n] - (s *= this.m_beta[k]);
                    for (i = k + 1; i < this.m_m; ++i) {
                        int n2 = i + jm;
                        this.m_qr[n2] = this.m_qr[n2] - s * this.m_qr[i + km];
                    }
                    ++j;
                    jm += this.m_m;
                }
            } else if (k == this.m_m - 1) {
                double nrm = -x1;
                this.m_beta[k] = 2.0;
                this.m_qr[k + km] = nrm;
            }
            ++k;
            km += this.m_m;
        }
    }

    public void QtB(double[] b) {
        int k = 0;
        int km = 0;
        while (k < this.m_n) {
            int i;
            double s = b[k];
            for (i = k + 1; i < this.m_m; ++i) {
                s += this.m_qr[km + i] * b[i];
            }
            int n = k;
            b[n] = b[n] - (s *= this.m_beta[k]);
            for (i = k + 1; i < this.m_m; ++i) {
                int n2 = i;
                b[n2] = b[n2] - s * this.m_qr[km + i];
            }
            ++k;
            km += this.m_m;
        }
    }

    public void QB(double[] b) {
        for (int k = this.m_n - 1; k >= 0; --k) {
            int i;
            double s = b[k];
            for (i = k + 1; i < this.m_m; ++i) {
                s += this.m_qr[k * this.m_m + i] * b[i];
            }
            int n = k;
            b[n] = b[n] - (s *= this.m_beta[k]);
            for (i = k + 1; i < this.m_m; ++i) {
                int n2 = i;
                b[n2] = b[n2] - s * this.m_qr[k * this.m_m + i];
            }
        }
    }
}

