/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class TransformSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String FN = "function";
    public static final String FCT = "fct";
    public static final String UNITS = "units";
    public static final String PRELIMINARYCHECK = "preliminarycheck";
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private double fct_ = 0.95;
    private boolean units_;
    private boolean preliminaryCheck_ = true;
    private DefaultTransformationType fn_ = DefaultTransformationType.None;
    public static final double DEF_FCT = 0.95;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, FN), String.class);
        dic.put(InformationSet.item(prefix, FCT), Double.class);
        dic.put(InformationSet.item(prefix, UNITS), Boolean.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
    }

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.fct_ = 0.95;
        this.units_ = false;
        this.preliminaryCheck_ = true;
        this.fn_ = DefaultTransformationType.None;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public DefaultTransformationType getFunction() {
        return this.fn_;
    }

    public void setFunction(DefaultTransformationType fn) {
        this.fn_ = fn;
    }

    public double getFct() {
        return this.fct_;
    }

    public void setFct(double value) {
        this.fct_ = value;
    }

    public boolean isUnits() {
        return this.units_;
    }

    public void setUnits(boolean value) {
        this.units_ = value;
    }

    public boolean isPreliminaryCheck() {
        return this.preliminaryCheck_;
    }

    public void setPreliminaryCheck(boolean value) {
        this.preliminaryCheck_ = value;
    }

    public boolean isDefault() {
        return !this.units_ && this.fn_ == DefaultTransformationType.None && this.fct_ == 0.95 && this.span_.getType() == PeriodSelectorType.All && this.preliminaryCheck_;
    }

    public TransformSpec clone() {
        try {
            TransformSpec spec = (TransformSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(TransformSpec other) {
        if (other == null) {
            return this.isDefault();
        }
        return this.fct_ == other.fct_ && this.fn_ == other.fn_ && this.units_ == other.units_ && Objects.equals(this.span_, other.span_) && this.preliminaryCheck_ == other.preliminaryCheck_;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TransformSpec && this.equals((TransformSpec)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.span_);
        hash = 61 * hash + Jdk6.Double.hashCode(this.fct_);
        hash = 61 * hash + (this.units_ ? 1 : 0);
        hash = 61 * hash + Objects.hashCode((Object)this.fn_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || this.fn_ != DefaultTransformationType.None) {
            info.add(FN, this.fn_.name());
        }
        if (verbose || this.fct_ != 0.95) {
            info.add(FCT, Double.valueOf(this.fct_));
        }
        if (verbose || this.units_) {
            info.add(UNITS, Boolean.valueOf(this.units_));
        }
        if (verbose || !this.preliminaryCheck_) {
            info.add(PRELIMINARYCHECK, Boolean.valueOf(this.preliminaryCheck_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean preliminaryChecks;
            Boolean units;
            Double fct;
            String fn;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((fn = info.get(FN, String.class)) != null) {
                this.fn_ = DefaultTransformationType.valueOf(fn);
            }
            if ((fct = info.get(FCT, Double.class)) != null) {
                this.fct_ = fct;
            }
            if ((units = info.get(UNITS, Boolean.class)) != null) {
                this.units_ = units;
            }
            if ((preliminaryChecks = info.get(PRELIMINARYCHECK, Boolean.class)) != null) {
                this.preliminaryCheck_ = preliminaryChecks;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

