/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.nonlinear;

import ec.benchmarking.Cumulator;
import ec.benchmarking.ssf.nonlinear.AbstractLinearizedDisaggregationSmoother;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.extended.LinearizedLogSsf;
import ec.tstoolkit.ssf.extended.LogSsf;

public class LinearizedLogSmoother<S extends ISsf>
extends AbstractLinearizedDisaggregationSmoother<LogSsf<S>, LinearizedLogSsf<S>> {
    public LinearizedLogSmoother(DataBlock y, int conv, S s) {
        super(y, conv, new LogSsf<S>(s));
    }

    @Override
    protected boolean calcInitialApproximation() {
        int i;
        double[] e = new double[this.m_y.length];
        for (int n = this.conversion - 1; n < e.length; n += this.conversion) {
            double w = this.m_y[n] / (double)this.conversion;
            for (i = 0; i < this.conversion; ++i) {
                e[n - i] = w;
            }
        }
        double[] tmp = new double[e.length];
        this.m_lssf = ((LogSsf)this.getNonLinearSsf()).linearApproximation(new DataBlock(tmp), new DataBlock(e));
        Cumulator cumul = new Cumulator(this.conversion);
        cumul.transform(tmp);
        this.m_yc = (double[])this.m_y.clone();
        for (i = 0; i < tmp.length; ++i) {
            if (!Double.isFinite(this.m_yc[i])) continue;
            int n = i;
            this.m_yc[n] = this.m_yc[n] + tmp[i];
        }
        return true;
    }

    @Override
    protected boolean calcNextApproximation() {
        double[] e = new double[this.m_y.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = ((LogSsf)this.getNonLinearSsf()).Z(i, this.m_states.block(i).drop(1, 0));
        }
        double[] tmp = new double[this.m_y.length];
        this.m_lssf = ((LogSsf)this.getNonLinearSsf()).linearApproximation(new DataBlock(tmp), new DataBlock(e));
        Cumulator cumul = new Cumulator(this.conversion);
        cumul.transform(tmp);
        this.m_yc = (double[])this.m_y.clone();
        for (int i = 0; i < tmp.length; ++i) {
            if (!Double.isFinite(this.m_yc[i])) continue;
            int n = i;
            this.m_yc[n] = this.m_yc[n] + tmp[i];
        }
        return true;
    }

    public DataBlock getBenchmarkedData() {
        if (this.m_lssf == null && !this.calc()) {
            return null;
        }
        return ((LinearizedLogSsf)this.m_lssf).getE();
    }
}

