/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import java.util.Map;

public class AutoModelSpec
implements Cloneable,
InformationSetSerializable {
    public static final String ENABLED = "enabled";
    public static final String PCR = "pcr";
    public static final String UB1 = "ub1";
    public static final String UB2 = "ub2";
    public static final String TSIG = "tsig";
    public static final String PC = "pc";
    public static final String CANCEL = "cancel";
    public static final String FAL = "fal";
    public static final String AMICOMPARE = "compare";
    private double cancel_ = 0.05;
    private double ub1_ = 0.97;
    private double ub2_ = 0.91;
    private double pcr_ = 0.95;
    private double pc_ = 0.12;
    private double tsig_ = 1.0;
    private boolean enabled_ = false;
    private boolean fal_ = false;
    private boolean amicompare_ = false;
    public static final double DEF_CANCEL = 0.05;
    public static final double DEF_PCR = 0.95;
    public static final double DEF_UB1 = 0.97;
    public static final double DEF_UB2 = 0.91;
    public static final double DEF_TSIG = 1.0;
    public static final double DEF_PC = 0.12;
    public static final boolean DEF_FAL = false;
    public static final boolean DEF_AMICOMPARE = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, CANCEL), Double.class);
        dic.put(InformationSet.item(prefix, UB1), Double.class);
        dic.put(InformationSet.item(prefix, UB2), Double.class);
        dic.put(InformationSet.item(prefix, TSIG), Double.class);
        dic.put(InformationSet.item(prefix, PC), Double.class);
        dic.put(InformationSet.item(prefix, PCR), Double.class);
        dic.put(InformationSet.item(prefix, ENABLED), Boolean.class);
        dic.put(InformationSet.item(prefix, FAL), Boolean.class);
        dic.put(InformationSet.item(prefix, AMICOMPARE), Boolean.class);
    }

    public AutoModelSpec() {
    }

    public AutoModelSpec(boolean enabled) {
        this.enabled_ = enabled;
    }

    public void reset() {
        this.cancel_ = 0.05;
        this.ub1_ = 0.97;
        this.ub2_ = 0.91;
        this.pcr_ = 0.95;
        this.pc_ = 0.12;
        this.tsig_ = 1.0;
        this.enabled_ = false;
        this.fal_ = false;
        this.amicompare_ = false;
    }

    public double getPcr() {
        return this.pcr_;
    }

    public void setPcr(double value) {
        if (value < 0.8 || value > 1.0) {
            throw new TramoException("PCR should belong to [0.8, 1.0]");
        }
        this.pcr_ = value;
    }

    public double getUb1() {
        return this.ub1_;
    }

    public void setUb1(double value) {
        if (value < 0.8 || value > 1.0) {
            throw new TramoException("UB1 should belong to [0.8, 1.0]");
        }
        this.ub1_ = value;
    }

    public double getUb2() {
        return this.ub2_;
    }

    public void setUb2(double value) {
        if (value < 0.8 || value > 1.0) {
            throw new TramoException("UB2 should belong to [0.8, 1.0]");
        }
        this.ub2_ = value;
    }

    public double getCancel() {
        return this.cancel_;
    }

    public void setCancel(double value) {
        if (value < 0.0 || value > 0.3) {
            throw new TramoException("Cancelation limit should belong to [0, 0.3]");
        }
        this.cancel_ = value;
    }

    public double getTsig() {
        return this.tsig_;
    }

    public void setTsig(double value) {
        if (value <= 0.5) {
            throw new TramoException("TSIG should be higher than 0.5");
        }
        this.tsig_ = value;
    }

    public double getPc() {
        return this.pc_;
    }

    public void setPc(double value) {
        if (value < 0.1 || value > 0.3) {
            throw new TramoException("PC should belong to [0.1, 0.3]");
        }
        this.pc_ = value;
    }

    public boolean isDefault() {
        return !this.enabled_ && !this.fal_ && this.cancel_ == 0.05 && this.pc_ == 0.12 && this.pcr_ == 0.95 && this.tsig_ == 1.0 && this.ub1_ == 0.97 && this.ub2_ == 0.91 && !this.amicompare_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean value) {
        this.enabled_ = value;
    }

    public boolean isAmiCompare() {
        return this.amicompare_;
    }

    public void setAmiCompare(boolean value) {
        this.amicompare_ = value;
    }

    public AutoModelSpec clone() {
        try {
            return (AutoModelSpec)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(AutoModelSpec other) {
        if (other == null) {
            return !this.enabled_;
        }
        return this.amicompare_ == other.amicompare_ && this.fal_ == other.fal_ && this.cancel_ == other.cancel_ && this.enabled_ == other.enabled_ && this.pc_ == other.pc_ && this.pcr_ == other.pcr_ && this.tsig_ == other.tsig_ && this.ub1_ == other.ub1_ && this.ub2_ == other.ub2_;
    }

    public static boolean equals(AutoModelSpec l, AutoModelSpec r) {
        if (l == r) {
            return true;
        }
        if (l != null) {
            return l.equals(r);
        }
        return r.equals(l);
    }

    public boolean isAcceptDefault() {
        return this.fal_;
    }

    public void setAcceptDefault(boolean fal) {
        this.fal_ = fal;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof AutoModelSpec && this.equals((AutoModelSpec)obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.enabled_ ? 1 : 0);
        hash = 17 * hash + (this.fal_ ? 1 : 0);
        hash = 17 * hash + (this.amicompare_ ? 1 : 0);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(ENABLED, Boolean.valueOf(this.enabled_));
        if (verbose || this.pcr_ != 0.95) {
            info.add(PCR, Double.valueOf(this.pcr_));
        }
        if (verbose || this.pc_ != 0.12) {
            info.add(PC, Double.valueOf(this.pc_));
        }
        if (verbose || this.ub1_ != 0.97) {
            info.add(UB1, Double.valueOf(this.ub1_));
        }
        if (verbose || this.ub2_ != 0.91) {
            info.add(UB2, Double.valueOf(this.ub2_));
        }
        if (verbose || this.cancel_ != 0.05) {
            info.add(CANCEL, Double.valueOf(this.cancel_));
        }
        if (verbose || this.fal_) {
            info.add(FAL, Boolean.valueOf(this.fal_));
        }
        if (verbose || this.amicompare_) {
            info.add(AMICOMPARE, Boolean.valueOf(this.amicompare_));
        }
        if (verbose || this.tsig_ != 1.0) {
            info.add(TSIG, Double.valueOf(this.tsig_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean fal;
            Boolean ami;
            Double tsig;
            Double pc;
            Double cancel;
            Double ub2;
            Double ub1;
            Double pcr;
            this.reset();
            Boolean enabled = info.get(ENABLED, Boolean.class);
            if (enabled != null) {
                this.enabled_ = enabled;
            }
            if ((pcr = info.get(PCR, Double.class)) != null) {
                this.pcr_ = pcr;
            }
            if ((ub1 = info.get(UB1, Double.class)) != null) {
                this.ub1_ = ub1;
            }
            if ((ub2 = info.get(UB2, Double.class)) != null) {
                this.ub2_ = ub2;
            }
            if ((cancel = info.get(CANCEL, Double.class)) != null) {
                this.cancel_ = cancel;
            }
            if ((pc = info.get(PC, Double.class)) != null) {
                this.pc_ = pc;
            }
            if ((tsig = info.get(TSIG, Double.class)) != null) {
                this.tsig_ = tsig;
            }
            if ((ami = info.get(AMICOMPARE, Boolean.class)) != null) {
                this.amicompare_ = ami;
            }
            if ((fal = info.get(FAL, Boolean.class)) != null) {
                this.fal_ = fal;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

