/*
 * Decompiled with CFR 0.152.
 */
package jd2.datatypes;

import java.util.function.IntSupplier;

public enum TsInformationType implements IntSupplier
{
    UserDefined(-1),
    None(0),
    Definition(1),
    MetaData(2),
    BaseInformation(3),
    Data(4),
    All(5);

    private final int value;

    private TsInformationType(int value) {
        this.value = value;
    }

    @Override
    public int getAsInt() {
        return this.value;
    }

    public boolean needsData() {
        return this == Data || this == All;
    }

    public TsInformationType union(TsInformationType rtype) {
        if (this == rtype) {
            return this;
        }
        if (this == All || rtype == All) {
            return All;
        }
        if (this == None) {
            return rtype;
        }
        if (rtype == None) {
            return this;
        }
        if (this == Data && rtype == Definition) {
            return Data;
        }
        if (this == Definition && rtype == Data) {
            return Data;
        }
        return All;
    }

    public boolean encompass(TsInformationType newtype) {
        switch (newtype) {
            case All: {
                return this == All;
            }
            case Data: {
                return this == Data || this == All;
            }
            case MetaData: {
                return this == MetaData || this == All;
            }
            case Definition: {
                return this == All || this == Data || this == Definition;
            }
        }
        return true;
    }
}

