/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.IVectorTransformation;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class HyperbolicRotation
implements IVectorTransformation {
    static final double XEPS = 1.0E-12;
    private int lentry_;
    private int rentry_;
    private double d_;
    private double ro_;
    private double a_;
    private double b_;

    public static HyperbolicRotation create(DataBlock vector, int entry) {
        return HyperbolicRotation.create(vector, 0, entry);
    }

    public static HyperbolicRotation create(DataBlock vector, int lentry, int rentry) {
        HyperbolicRotation r;
        double a = vector.get(lentry);
        double b = vector.get(rentry);
        double ra = Math.abs(a);
        double rb = Math.abs(b);
        if (rb < 1.0E-12) {
            vector.set(rentry, 0.0);
            return null;
        }
        if (Math.abs(ra - rb) < 1.0E-12) {
            r = new HyperbolicRotation(lentry, rentry, a == b);
            vector.set(lentry, 0.0);
            vector.set(rentry, 0.0);
        } else {
            r = new HyperbolicRotation(a, lentry, b, rentry);
            if (Math.abs(a) > Math.abs(b)) {
                vector.set(lentry, a * r.d_);
                vector.set(rentry, 0.0);
            } else {
                vector.set(rentry, b * r.d_);
                vector.set(lentry, 0.0);
            }
        }
        return r;
    }

    private HyperbolicRotation(int lentry, int rentry, boolean same) {
        this.lentry_ = lentry;
        this.rentry_ = rentry;
        this.ro_ = same ? 1.0 : -1.0;
    }

    private HyperbolicRotation(double a, int lentry, double b, int rentry) {
        this.lentry_ = lentry;
        this.rentry_ = rentry;
        if (a == 0.0 || b == 0.0) {
            this.ro_ = 0.0;
            this.d_ = 1.0;
            this.b_ = 0.0;
            this.a_ = 1.0;
        } else if (Math.abs(a) > Math.abs(b)) {
            this.ro_ = b / a;
            this.d_ = Math.sqrt(1.0 - this.ro_ * this.ro_);
            if (a < 0.0) {
                this.d_ = -this.d_;
            }
            this.a_ = a;
            this.b_ = b;
        } else {
            this.ro_ = a / b;
            this.d_ = Math.sqrt(1.0 - this.ro_ * this.ro_);
            if (b < 0.0) {
                this.d_ = -this.d_;
            }
            this.a_ = b;
            this.b_ = a;
        }
    }

    @Override
    public void transform(DataBlock vector) {
        double a = vector.get(this.lentry_);
        double b = vector.get(this.rentry_);
        if (this.d_ == 0.0) {
            if (this.ro_ == 1.0) {
                double s = a - b;
                vector.set(this.lentry_, s);
                vector.set(this.rentry_, -s);
            } else {
                double s = a + b;
                vector.set(this.lentry_, s);
                vector.set(this.rentry_, s);
            }
        } else {
            this.H(vector);
        }
    }

    private void OD(DataBlock vector, double x, double y) {
        double x1 = x - y;
        double y1 = x + y;
        double z = (this.a_ + this.b_) / (this.a_ - this.b_);
        z = Math.sqrt(z);
        vector.set(this.lentry_, (x1 *= 0.5 * z) + (y1 *= 0.5 / z));
        vector.set(this.rentry_, y1 - x1);
    }

    private void H(DataBlock vector) {
        double e;
        double z;
        double ry;
        double x = vector.get(this.lentry_);
        double y = vector.get(this.rentry_);
        int l = this.lentry_;
        int r = this.rentry_;
        double rx = Math.abs(x);
        if (rx < (ry = Math.abs(y))) {
            double t = rx;
            rx = ry;
            ry = t;
            t = x;
            x = y;
            y = t;
            int it = l;
            l = r;
            r = it;
        }
        if ((z = this.ro_ * y / x) < 0.5) {
            e = 1.0 - z;
        } else {
            double d1 = 1.0 - Math.abs(this.ro_);
            double d2 = 1.0 - ry / rx;
            e = d1 + d2 - d1 * d2;
        }
        double x1 = Math.abs(this.a_) * x * e / Math.sqrt(Math.abs((this.a_ - this.b_) * (this.a_ + this.b_)));
        double y1 = x1 - Math.sqrt(Math.abs((this.a_ + this.b_) / (this.a_ - this.b_))) * (x - y);
        vector.set(l, x1);
        vector.set(r, y1);
    }

    public static boolean triangularize(SubMatrix M, int npos) {
        int r = M.getRowsCount();
        int c = M.getColumnsCount();
        ElementaryTransformations.fastGivensTriangularize(M.extract(0, r, 0, npos));
        ElementaryTransformations.fastGivensTriangularize(M.extract(0, r, npos, c));
        try {
            SubMatrix L = M;
            do {
                HyperbolicRotation.makeHyperbolicRotation(L, npos--);
            } while (!(L = L.extract(1, r--, 1, c--)).isEmpty());
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    private static void makeHyperbolicRotation(SubMatrix L, int npos) {
        int ncols = L.getColumnsCount();
        DataBlockIterator rows = L.rows();
        DataBlock cur = rows.getData();
        for (int i = npos; i < ncols; ++i) {
            rows.begin();
            HyperbolicRotation rotation = HyperbolicRotation.create(cur, i);
            if (rotation == null) continue;
            while (rows.next()) {
                rotation.transform(cur);
            }
        }
    }

    public static double jhypotenuse(double x, double y) {
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double w = Math.max(xabs, yabs);
        double z = Math.min(xabs, yabs);
        if (z == 0.0) {
            return w;
        }
        double zw = z / w;
        return w * Math.sqrt(1.0 - zw * zw);
    }
}

