/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IoUtil {
    private IoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void closeAll(@NonNull Closeable first, @NonNull Closeable second) throws IOException {
        try {
            first.close();
        }
        catch (IOException ex) {
            throw IoUtil.ensureClosed(ex, second);
        }
        second.close();
    }

    public static <T extends Throwable> T ensureClosed(@NonNull T ex, @NonNull Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException suppressed) {
            ex.addSuppressed(suppressed);
        }
        return ex;
    }

    public static <T> @NonNull Supplier<Iterable<T>> supplierOfServiceLoader(@NonNull Class<T> type) {
        return () -> ServiceLoader.load(type);
    }
}

