/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client.custom;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import it.bankitalia.reri.sia.sdmx.client.RestSdmxClient;
import it.bankitalia.reri.sia.sdmx.parser.v20.DataStructureParser;
import it.bankitalia.reri.sia.sdmx.parser.v20.GenericDataParser;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OECD
extends RestSdmxClient {
    protected static Logger logger = Configuration.getSdmxLogger();

    public OECD() throws MalformedURLException {
        super("OECD", new URL("http://stats.oecd.org/restsdmx/sdmx.ashx/"), "OECD", false, true);
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(String string, DataFlowStructure dataFlowStructure, String string2, String string3, String string4) throws SdmxException {
        String string5 = null;
        String string6 = null;
        ArrayList<PortableTimeSeries> arrayList = new ArrayList();
        string5 = this.buildDataQuery(this.wsEndpoint, string, string2, string3, string4);
        string6 = this.runQuery(string5, null);
        if (string6 != null && !string6.isEmpty()) {
            logger.finest(string6);
            try {
                arrayList = GenericDataParser.parse(string6, string);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier) throws SdmxException {
        String string = null;
        String string2 = null;
        DataFlowStructure dataFlowStructure = new DataFlowStructure();
        if (dSDIdentifier == null) throw new SdmxException("Null dsd in input");
        string = this.buildStructureQuery(this.wsEndpoint, dSDIdentifier.getId());
        string2 = this.runQuery(string, null);
        if (string2 == null) throw new SdmxException("The query returned an empty result");
        if (string2.isEmpty()) throw new SdmxException("The query returned an empty result");
        logger.finest(string2);
        try {
            return DataStructureParser.parse(string2).get(0);
        }
        catch (Exception exception) {
            logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
            logger.log(Level.FINER, "Exception: ", exception);
            throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
        }
    }

    @Override
    public DSDIdentifier getDSDIdentifier(String string, String string2) throws SdmxException {
        DSDIdentifier dSDIdentifier = new DSDIdentifier(string, this.getAgency(), string2);
        return dSDIdentifier;
    }

    @Override
    public Map<String, String> getDataflows() throws SdmxException {
        HashMap<String, String> hashMap;
        block5: {
            String string = null;
            String string2 = null;
            hashMap = new HashMap<String, String>();
            string = this.buildFlowQuery(this.wsEndpoint, "ALL");
            string2 = this.runQuery(string, null);
            if (string2 != null && !string2.isEmpty()) {
                logger.finest(string2);
                try {
                    List<DataFlowStructure> list = DataStructureParser.parse(string2);
                    if (list.size() > 0) {
                        hashMap = new HashMap();
                        for (DataFlowStructure dataFlowStructure : list) {
                            hashMap.put(dataFlowStructure.getId(), dataFlowStructure.getName());
                        }
                        break block5;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            throw new SdmxException("The query returned an empty result");
        }
        return hashMap;
    }

    @Override
    protected String buildDataQuery(URL uRL, String string, String string2, String string3, String string4) {
        if (uRL != null && string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            String string5 = uRL + "/GetData/" + string + "/";
            string5 = string5 + string2;
            if (string3 != null && string3.isEmpty()) {
                string3 = null;
            }
            if (string4 != null && string4.isEmpty()) {
                string4 = null;
            }
            if (string3 != null || string4 != null) {
                string5 = string5 + "?";
                if (string3 != null) {
                    string5 = string5 + "startPeriod=" + string3;
                }
                if (string3 != null && string4 != null) {
                    string5 = string5 + "&";
                }
                if (string4 != null) {
                    string5 = string5 + "endPeriod=" + string4;
                }
            }
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + string + " resource=" + string2 + " endpoint=" + uRL);
    }

    protected String buildStructureQuery(URL uRL, String string) {
        if (uRL != null && string != null && !string.isEmpty()) {
            String string2 = uRL + "/GetDataStructure/" + string;
            return string2;
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + uRL);
    }

    protected String buildFlowQuery(URL uRL, String string) {
        return this.buildStructureQuery(uRL, string);
    }
}

