/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.parser.v21;

import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.LocalizedText;
import it.bankitalia.reri.sia.util.SdmxException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CodelistParser {
    private static final String sourceClass = CodelistParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String CODELISTS = "Codelists";
    static final String CODELIST = "Codelist";
    static final String NAME = "Name";
    static final String VALUE = "Code";
    static final String KEY = "id";

    public static Map<String, String> parse(String string) throws XMLStreamException, SdmxException, UnsupportedEncodingException {
        logger.entering(sourceClass, "parse");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(byteArrayInputStream);
        Map<String, String> map = CodelistParser.getCodes(xMLEventReader);
        logger.exiting(sourceClass, "parse");
        return map;
    }

    public static Map<String, String> getCodes(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        LocalizedText localizedText = new LocalizedText();
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (object.getName().getLocalPart() == VALUE) {
                    string = null;
                    localizedText = new LocalizedText();
                    logger.finest("Got code element.");
                    Iterator<Attribute> iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.getName().toString().equals(KEY)) continue;
                        string = attribute.getValue();
                    }
                } else if (object.getName().getLocalPart() == NAME) {
                    localizedText.setText((StartElement)object, xMLEventReader);
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            object = xMLEvent.asEndElement().getName().getLocalPart();
            if (((String)object).equals(VALUE)) {
                if (string != null) {
                    hashtable.put(string, localizedText.getText());
                    continue;
                }
                throw new SdmxException("Error during Codelist Parsing. Invalid code id: " + string);
            }
            if (!((String)object).equals(CODELIST)) continue;
            break;
        }
        return hashtable;
    }
}

