/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.parser.v21;

import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.util.LocalizedText;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataflowParser {
    private static final String DATAFLOW = "Dataflow";
    private static final String ID = "id";
    private static final String AGENCY = "agencyID";
    private static final String VERSION = "version";
    private static final String NAME = "Name";
    private static final String REF = "Ref";

    public static List<Dataflow> parse(String string) throws XMLStreamException, UnsupportedEncodingException {
        ArrayList<Dataflow> arrayList = new ArrayList<Dataflow>();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(byteArrayInputStream);
        Dataflow dataflow = null;
        LocalizedText localizedText = new LocalizedText();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                String string2;
                String string3;
                String string4;
                Attribute attribute;
                Iterator<Attribute> iterator;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == DATAFLOW) {
                    dataflow = new Dataflow();
                    iterator = xMLEvent.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        string4 = null;
                        string3 = null;
                        string2 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string4 = attribute.getValue();
                            dataflow.setId(string4);
                            continue;
                        }
                        if (attribute.getName().toString().equals(AGENCY)) {
                            string3 = attribute.getValue();
                            dataflow.setAgency(string3);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(VERSION)) continue;
                        string2 = attribute.getValue();
                        dataflow.setVersion(string2);
                    }
                } else if (xMLEvent.getName().getLocalPart() == NAME) {
                    localizedText.setText((StartElement)xMLEvent, xMLEventReader);
                } else if (xMLEvent.getName().getLocalPart() == REF) {
                    iterator = xMLEvent.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        string4 = null;
                        string3 = null;
                        string2 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string4 = attribute.getValue();
                            dataflow.setDsd(string4);
                            continue;
                        }
                        if (attribute.getName().toString().equals(AGENCY)) {
                            string3 = attribute.getValue();
                            dataflow.setDsdAgency(string3);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(VERSION)) continue;
                        string2 = attribute.getValue();
                        dataflow.setDsdVersion(string2);
                    }
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != DATAFLOW) continue;
            dataflow.setName(localizedText.getText());
            arrayList.add(dataflow);
        }
        return arrayList;
    }
}

