/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.helper.NodeComparator;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

public class SdmxNode {
    protected static Logger logger = Configuration.getSdmxLogger();
    protected String id;
    protected String description;
    private boolean orderLexicographically;

    public SdmxNode(String string, String string2, boolean bl) {
        this.id = string;
        this.description = string2;
        this.orderLexicographically = bl;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getId() + " : " + this.getDescription();
    }

    public void expand(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        List<SdmxNode> list = null;
        try {
            list = this.listSubNodes();
        }
        catch (SdmxException sdmxException) {
            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            logger.log(Level.FINER, "", sdmxException);
        }
        if (list != null) {
            if (this.orderLexicographically) {
                Collections.sort(list, new NodeComparator());
            }
            for (int i = 0; i < list.size(); ++i) {
                SdmxNode sdmxNode = list.get(i);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(sdmxNode);
                if (sdmxNode.hasSubNodes()) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new SdmxNode("Calling provider, please wait...", "", false)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public boolean hasSubNodes() {
        return true;
    }

    public List<SdmxNode> listSubNodes() throws SdmxException {
        return null;
    }
}

