/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.acceptance;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.acceptance.AllAccept;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.NotFoundException;

public class TestDatabaseModes
extends AssemblerTestBase {
    public TestDatabaseModes(String name) {
        super(name);
    }

    public void testRDBModelOpenedWhenExists() {
        this.openWith("square", false, true);
        this.openWith("circle", true, true);
    }

    public void testRDBModelCreatedWhenMissing() {
        this.openWith("line", true, true);
        this.openWith("edge", true, false);
    }

    public void testRDBModelFailsIfExists() {
        try {
            this.openWith("triangle", true, false);
            AllAccept.fail((String)"should trap existing model");
        }
        catch (AlreadyExistsException e) {
            AllAccept.assertEquals((String)"triangle", (String)e.getMessage());
        }
        try {
            this.openWith("hex", false, false);
            AllAccept.fail((String)"should trap existing model");
        }
        catch (AlreadyExistsException e) {
            AllAccept.assertEquals((String)"hex", (String)e.getMessage());
        }
    }

    public void testRDBModelFailsIfMissing() {
        try {
            this.openWith("parabola", false, true);
            AllAccept.fail((String)"should trap missing model");
        }
        catch (NotFoundException e) {
            AllAccept.assertEquals((String)"parabola", (String)e.getMessage());
        }
        try {
            this.openWith("curve", false, false);
            AllAccept.fail((String)"should trap missing model");
        }
        catch (NotFoundException e) {
            AllAccept.assertEquals((String)"curve", (String)e.getMessage());
        }
    }

    private void openWith(String name, boolean mayCreate, boolean mayReuse) {
        Assembler.general.openModel(this.getRoot(name), new Mode(mayCreate, mayReuse)).close();
    }

    private Resource getRoot(String name) {
        return this.resourceInModel(this.getDescription(name));
    }

    private String getDescription(String modelName) {
        return "x rdf:type ja:RDBModel; x ja:modelName 'spoo'; x ja:connection C; C ja:dbURLProperty 'jena.db.url'; C ja:dbUserProperty 'jena.db.user'; C ja:dbPasswordProperty 'jena.db.password'; C ja:dbTypeProperty 'jena.db.type'; C ja:dbClassProperty 'jena.db.driver'".replaceAll("spoo", modelName);
    }
}

