\name{PrecipitationEndDay}
\alias{PrecipitationEndDay}
\title{Gets the last day in a precipitation time series, expressed in decimal julian days since 1970-1-1 00:00 UTC}
\usage{
  PrecipitationEndDay(name, station_names, end_day)
}
\arguments{
  \item{name}{charcacter ID of the station}

  \item{station_names}{vector containing the IDs
  (characters) of the considered meteorological stations.
  An example is \code{STATION_NAMES} defined in
  \code{\link{trentino}}.}

  \item{end_day}{vector containing the measurement end day.
  An example is \code{TEMPERATURE_MEASUREMENT_END_DAY}
  defined in \code{\link{trentino}}.}
}
\value{
  the precipitation measurement end day given the vectors
  of station IDs and the precipitation measurement end days
}
\description{
  Gets the last day in a precipitation time series,
  expressed in decimal julian days since 1970-1-1 00:00 UTC
}
\examples{
data(trentino)
PrecipitationEndDay("T0099",station_names=STATION_NAMES,end_day=PRECIPITATION_MEASUREMENT_END_DAY)
}
\author{
  Emanuele Cordano, Emanuele Eccel
}

