% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{predict.MOA_trainedmodel}
\alias{predict.MOA_trainedmodel}
\title{Predict using a MOA classifier, MOA regressor or MOA recommender on a new dataset}
\usage{
\method{predict}{MOA_trainedmodel}(object, newdata, type = "response",
  transFUN = object$transFUN, na.action = na.fail, ...)
}
\arguments{
\item{object}{an object of class \code{MOA_trainedmodel}, as returned by \code{\link{trainMOA}}}

\item{newdata}{a data.frame with the same structure and the same levels as used in \code{trainMOA} for MOA classifier, MOA regressor,
a data.frame with at least the user/item columns which were used in \code{\link{trainMOA}} when training
the MOA recommendation engine}

\item{type}{a character string, either 'response' or 'votes'}

\item{transFUN}{a function which is used on \code{newdata} 
before applying \code{\link{model.frame}}. 
Useful if you want to change the results \code{get_points} on the datastream 
(e.g. for making sure the factor levels are the same in each chunk of processing, some data cleaning, ...). 
Defaults to \code{transFUN} available in \code{object}.}

\item{na.action}{passed on to model.frame when constructing the model.matrix from \code{newdata}. Defaults to \code{na.fail}.}

\item{...}{other arguments, currently not used yet}
}
\value{
A matrix of votes or a vector with the predicted class for MOA classifier or MOA regressor.
A
}
\description{
Predict using a MOA classifier, MOA regressor or MOA recommender on a new dataset. \\
Make sure the new dataset has the same structure
and the same levels as \code{get_points} returns on the datastream which was used in \code{trainMOA}
}
\examples{
## Hoeffdingtree
hdt <- HoeffdingTree(numericEstimator = "GaussianNumericAttributeClassObserver")
data(iris)
## Make a training set
iris <- factorise(iris)
traintest <- list()
traintest$trainidx <- sample(nrow(iris), size=nrow(iris)/2)
traintest$trainingset <- iris[traintest$trainidx, ]
traintest$testset <- iris[-traintest$trainidx, ]
irisdatastream <- datastream_dataframe(data=traintest$trainingset)
## Train the model
hdtreetrained <- trainMOA(model = hdt, 
 Species ~ Sepal.Length + Sepal.Width + Petal.Length + Petal.Width, 
 data = irisdatastream)

## Score the model on the holdoutset
scores <- predict(hdtreetrained, 
   newdata=traintest$testset[, c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")], 
   type="response")
str(scores)
table(scores, traintest$testset$Species)
scores <- predict(hdtreetrained, newdata=traintest$testset, type="votes")
head(scores)

## Prediction based on recommendation engine
require(recommenderlab)
data(MovieLense)
x <- getData.frame(MovieLense)
x$itemid <- as.integer(as.factor(x$item))
x$userid <- as.integer(as.factor(x$user))
x$rating <- as.numeric(x$rating)
x <- head(x, 2000)

movielensestream <- datastream_dataframe(data=x)
movielensestream$get_points(3)

ctrl <- MOAoptions(model = "BRISMFPredictor", features = 10)
brism <- BRISMFPredictor(control=ctrl)
mymodel <- trainMOA(model = brism, rating ~ userid + itemid, 
 data = movielensestream, chunksize = 1000, trace=TRUE)

overview <- summary(mymodel$model)
str(overview)
predict(mymodel, head(x, 10), type = "response")

x <- expand.grid(userid=overview$users[1:10], itemid=overview$items)
predict(mymodel, x, type = "response")
}
\seealso{
\code{\link{trainMOA}}
}
