% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_getter.R
\name{getMixtureDensity}
\alias{getMixtureDensity}
\title{Get the mixture density}
\usage{
getMixtureDensity(outMixtComp)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or
\code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}
}
\value{
a vector containing the mixture density for each individual.
}
\description{
Get the mixture density for each individual
}
\details{
\deqn{d(x_i) = \sum_k\pi_k P(x_i; \theta_k)}
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

d <- getMixtureDensity(resLearn)

}
\seealso{
Other getter: 
\code{\link{getBIC}()},
\code{\link{getCompletedData}()},
\code{\link{getEmpiricTik}()},
\code{\link{getParam}()},
\code{\link{getPartition}()},
\code{\link{getType}()}
}
\author{
Quentin Grimonprez
}
\concept{getter}
