/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.abstracts.EFetch;
import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Map;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class RequestEFetch
implements RequestInterface {
    private static final String[] databases = new String[]{"pubmed", "nlmc", "taxon", "omim", "snp", "sequence", "journals", "gene"};
    private static final String[] classNames = new String[]{"de.hzi.infg.efetch.EFetchPubmed", "de.hzi.infg.efetch.EFetchNlmc", "de.hzi.infg.efetch.EFetchTaxon", "de.hzi.infg.efetch.EFetchOmim", "de.hzi.infg.efetch.EFetchSNP", "de.hzi.infg.efetch.EFetchSequence", "de.hzi.infg.efetch.EFetchJournals", "de.hzi.infg.efetch.EFetchGene"};
    private HttpTransportProperties.ProxyProperties proxyProperties;
    private EFetch efetchObject;

    public RequestEFetch(String db) throws ErrorFromWebserviceExeption, RemoteException, RuntimeException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        boolean databaseFound = false;
        if (db == null || db.isEmpty()) {
            throw new ErrorFromWebserviceExeption("No database selected.");
        }
        int i = 0;
        while (i < databases.length) {
            if (db.equalsIgnoreCase(databases[i])) {
                databaseFound = true;
                Class<?> eFetchClazz = Class.forName(classNames[i]);
                Constructor<?> con = eFetchClazz.getConstructor(new Class[0]);
                this.efetchObject = (EFetch)con.newInstance(new Object[0]);
            }
            i = (byte)(i + 1);
        }
        if (!databaseFound) {
            String dbOptions = "";
            int i2 = 0;
            while (i2 < databases.length) {
                dbOptions = i2 == databases.length - 1 ? String.valueOf(dbOptions) + databases[i2] : String.valueOf(dbOptions) + databases[i2] + ", ";
                ++i2;
            }
            throw new ErrorFromWebserviceExeption("Wrong database selected. Please select one from these databases:\n" + dbOptions);
        }
    }

    public void CallService(Map<String, String> argMap) throws ErrorFromWebserviceExeption, RemoteException {
        this.efetchObject.setRequestParameter(argMap);
        this.efetchObject.setProxyProperties(this.proxyProperties);
        this.efetchObject.fireRequest();
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        return this.efetchObject.getComplexType(name);
    }

    @Override
    public String[] getParameter() {
        return this.efetchObject.getParameter();
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        return this.efetchObject.getParameterByName(parameter);
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        return this.efetchObject.getResultMap();
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        return this.efetchObject.getSimpleType(name);
    }

    public String[] getOperationParameter() throws IllegalStateException {
        if (this.efetchObject == null) {
            throw new IllegalStateException("Please initialize the eFetch operation first.");
        }
        return this.efetchObject.getOperationParameter();
    }

    public static String[] getDatabases() {
        String[] tmp = Arrays.copyOf(databases, databases.length);
        Arrays.sort(tmp, String.CASE_INSENSITIVE_ORDER);
        return tmp;
    }

    public void setProxyProperties(HttpTransportProperties.ProxyProperties proxyProperties) {
        this.proxyProperties = proxyProperties;
    }

    public HttpTransportProperties.ProxyProperties getProxyProperties() {
        return this.proxyProperties;
    }

    public Object getResult() {
        return this.efetchObject.getResult();
    }
}

