% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DINT.R
\name{DINT}
\alias{DINT}
\title{Direct-INT}
\usage{
DINT(y, G, X = NULL, k = 3/8, parallel = F)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates and structure adjustments. Should include
an intercept. Omit to perform marginal tests of association.}

\item{k}{Offset applied during rank-normalization. See 
\code{\link{rankNorm}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}
}
\value{
A numeric matrix of score statistics and p-values, one for each locus
  (column) in \code{G}, assessing the null hypothesis of no genetic effect.
}
\description{
Applies the rank-based inverse normal transformation (\code{\link{rankNorm}})
to the phenotype \code{y}. Conducts tests of association between the loci in
\code{G} and transformed phenotype, adjusting for the model matrix \code{X}.
}
\examples{
\dontrun{
set.seed(100);
# Design matrix
X = cbind(1,rnorm(1e3));
# Genotypes
G = replicate(1e3,rbinom(n=1e3,size=2,prob=0.25));
storage.mode(G) = "numeric";
# Phenotype
y = exp(as.numeric(X\%*\%c(1,1))+rnorm(1e3));
# Association test
p = DINT(y=y,G=G,X=X);
}
}
