% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{network.aggregate}
\alias{network.aggregate}
\title{Aggregate the edges of a network by vertex attributes}
\usage{
network.aggregate(
  g,
  by = NULL,
  by.from = by,
  by.to = by,
  edge.attribute = "weight",
  agg.FUN = mean,
  return.df = FALSE,
  keep_isolates = T
)
}
\arguments{
\item{g}{A network/graph in the \link[igraph]{igraph} class}

\item{by}{A character string indicating the vertex attributes by which the edges will be aggregated.}

\item{by.from}{Optionally, specify different vertex attributes to aggregate the `from` side of edges}

\item{by.to}{Optionally, specify different vertex attributes to aggregate the `to` side of edges}

\item{edge.attribute}{Select an edge attribute to aggregate using the function specified in `agg.FUN`. Defaults to 'weight'}

\item{agg.FUN}{The function used to aggregate the edge attribute}

\item{return.df}{Optional. If TRUE, the results are returned as a data.frame. This can in particular be convenient if by.from and by.to are used.}

\item{keep_isolates}{if True, also return scores for isolates}
}
\value{
A network/graph in the \link[igraph]{igraph} class, or a data.frame if return.df is TRUE.
}
\description{
This function offers a versatile way to aggregate the edges of a network based on the vertex attributes.
Although it was designed specifically for document similarity networks, it can be used for any network in the \link[igraph]{igraph} class.
}
\details{
The first argument is the network (in the `igraph` class). 
The second argument, for the `by` parameter, is a character vector to indicate one or more vertex attributes based on which the edges are aggregated.
Optionally, the `by` parameter can also be specified separately for `by.from` and `by.to`. 

By default, the function returns the aggregated network as an \link[igraph]{igraph} class.
The edges in the aggregated network have five standard attributes. 
The `edges` attribute counts the number of edges from the `from` group to the `to` group. 
The `from.V` attribute shows the number of vertices in the `from` group that matched with a vertex in the `to` group.
The `from.Vprop attribute shows this as the proportion of all vertices in the `from` group.
The `to.V` and `to.Vprop` attributes show the same for the `to` group.

In addition, one of the edge attributes of the original network can be aggregated with a given function.
These are specified in the `edge.attribute` and `agg.FUN` parameters.
}
\examples{
data(docnet)
aggdocnet = network.aggregate(docnet, by='sourcetype')
igraph::get.data.frame(aggdocnet, 'both')

aggdocdf = network.aggregate(docnet, by.from='sourcetype', by.to='source', return.df = TRUE)
head(aggdocdf)
}
