% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGainsTable.R
\name{plot.gainstable}
\alias{plot.gainstable}
\title{Plot \code{"gainstable"} Object}
\usage{
\method{plot}{gainstable}(
  x,
  y = NULL,
  type = 1,
  col = c("#BEBEBE", "#26484F", "#8B4500"),
  legend = TRUE,
  ... = NULL
)
}
\arguments{
\item{x}{An object of class \code{"gainstable"}, created with
the function \code{\link{gainstable}}.}

\item{y}{\code{NULL}.}

\item{type}{Plot type. See "Details".}

\item{col}{Colors to be used for plot.}

\item{legend}{A logical value indicating whether legend to appear.
See "Details"}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
An S3 method to make different plots using
entries of gains table.
}
\details{
Currently three types are available. \code{type = 1} shows
lift and cumulative lift against population depth. \code{type = 2}
shows response
rate and cumulative response rate against population depth.
 \code{type = 3} shows
cumulative capture rate of positive responses against population depth.
For \code{type} 1 and 2, three colors and for 3, two colors
are required.
If more than required specified, then first 3 (for \code{type} 1, 2) or
2 (for \code{type} 3) colors are used. If less than required specified,
then
specified colors are repeated.
If \code{legend} is \code{TRUE},
then legend appears in the plot. For \code{type} 1 and 2, legend
position is \code{"topright"}, for 3, \code{"bottomright"}.
}
\examples{
data("Loan")
class <- Loan$Status
score <- Loan$Score
rocit_emp <- rocit(score = score, class = class, negref = "FP")
# ----------------------------------------------------------------
gtable <- gainstable(rocit_emp)
# ----------------------------------------------------------------
plot(gtable)
plot(gtable, legend = FALSE)
plot(gtable, col = 2:4)
plot(gtable, type = 2, col = 2:4)
plot(gtable, type = 3, col = 2:3)
}
\seealso{
\code{\link{gainstable}}, \code{\link{rocit}}
}
