% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{autoCalibrate2,RPhosFate-method}
\alias{autoCalibrate2,RPhosFate-method}
\alias{autoCalibrate2}
\title{Two dimensional automatic model calibration}
\usage{
\S4method{autoCalibrate2}{RPhosFate}(
  x,
  substance,
  col,
  metric,
  method = "Nelder-Mead",
  lower = 0,
  upper = 0.1,
  control = list(fnscale = if (metric \%in\% c("NSE", "mNSE", "KGE")) -1 else 1)
)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}

\item{col}{A character string specifying the calibration data column with the
respective substance river loads.}

\item{metric}{A character string specifying the metric to optimise. See
\code{\link{calibrationQuality}} for available metrics.}

\item{method}{A character string specifying the utilised optimisation method.
See \code{\link{optim}} for further information (use \code{\link{autoCalibrate}} instead of
method \code{"Brent"}).}

\item{lower}{A numeric scalar or vector specifying the lower end-point(s) of
the interval(s) to be searched.}

\item{upper}{A numeric scalar or vector specifying the upper end-point(s) of
the interval(s) to be searched.}

\item{control}{A \code{\link{list}} of control parameters passed on to \code{\link{optim}}. See
\code{\link{optim}} for further information.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Automatically calibrates the model with the help of a general-purpose
optimisation function. In contrast to \code{\link{autoCalibrate}}, this method always
utilises the overland and channel deposition rate at the same time and never
the respective enrichment ratio for calibration. Beware of local optima and
parameters approximately within the convergence tolerance of interval
end-points.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- firstRun(x, "SS")
x <- snapGauges(x)

x <- autoCalibrate2(
  x,
  "SS",
  col = "SS_load",
  metric = "NSE",
  method = "L-BFGS-B",
  lower = c(10e-4, 0),
  upper = c(20e-4, 20e-4),
  control = list(fnscale = -1, parscale = c(1e-3, 1e-3), factr = 1e12)
)}

}
\seealso{
\code{\link{snapGauges}}
}
