% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{add_chunk}
\alias{add_chunk}
\title{Add a chunk field to a data frame}
\usage{
add_chunk(
  value,
  chunk_size = 750000,
  chunk_fields = NULL,
  new_chunk_field_name = "chunk_idx"
)
}
\arguments{
\item{value}{The original data frame.}

\item{chunk_size}{Maximum size (in bytes) of each unique chunk. Default to
750,000 bytes.}

\item{chunk_fields}{A character vector of existing field names that are used
to split the data frame.}

\item{new_chunk_field_name}{A string indicating the new chunk field name.
Default to "chunk".}
}
\description{
This auxiliary function adds a field, if necessary, to a data frame so that
each compartment of the data frame that corresponds to a unique combination
of the chunk fields has a size below a certain threshold. This resulting
data frame can then be safely used in dbAppendTable() becauase Presto has a
size limit on any discrete INSERT INTO statement.
}
\examples{
\dontrun{
# returns the original data frame because it's within size
add_chunk(iris)
# add a new chunk_idx field
add_chunk(iris, chunk_size = 2000)
# the new chunk_idx field is added on top of Species
add_chunk(iris, chunk_size = 2000, chunk_fields = c("Species"))
}
}
