% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrestoQuery.R
\docType{class}
\name{PrestoQuery-class}
\alias{PrestoQuery-class}
\alias{PrestoQuery}
\title{Class to encapsulate a Presto query}
\description{
This reference class (so that the object can be passed by reference and
modified) encapsulates the lifecycle of a Presto query from its inception
(by providing a PrestoConnection and a query statement) to the steps it takes
to execute (i.e. an initial POST request and subsequent GET requests).
}
\details{
This is similar to the PrestoQuery class defined in the Presto Python client
}
\section{Slots}{

\describe{
\item{\code{.conn}}{A PrestoConnection object}

\item{\code{.statement}}{The query statement}

\item{\code{.id}}{The query ID returned after the first POST request}

\item{\code{.timestamp}}{The timestamp of the query execution}

\item{\code{.bigint}}{How BIGINT fields should be converted to an R class}

\item{\code{.state}}{The query state. This changes every time the query advances to
the next stage}

\item{\code{.next.uri}}{The URI that specifies the next endpoint to send the GET
request}

\item{\code{.info.uri}}{The information URI}

\item{\code{.stats}}{Query stats. This changes every time the query advances to the
next stage}

\item{\code{.response}}{HTTP request response. This changes when the query advances}

\item{\code{.content}}{Parsed content from the HTTP request response}

\item{\code{.fetched.row.count}}{How many rows of data have been fetched to R}

\item{\code{.post.data.fetched}}{A boolean flag indicating if data returned from the
POST request has been fetched}

\item{\code{.quiet}}{If a progress bar should be shown for long queries (which run
for more than 2 seconds. Default to \code{NA} which turns on the
progress bar for interactive queries.}
}}


\keyword{internal}
