% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{presto_default}
\alias{presto_default}
\alias{presto_has_default}
\title{Check if default database is available.}
\usage{
presto_default(...)

presto_has_default(...)
}
\arguments{
\item{...}{Additional arguments passed on to \code{\link[=dbConnect]{dbConnect()}}}
}
\description{
\code{presto_default()} works similarly but returns a connection on success and
throws a testthat skip condition on failure, making it suitable for use in
tests.

RPresto examples and tests connect to a default database via
\code{dbConnect(Presto(), ...)}. This function checks if that
database is available, and if not, displays an informative message.
}
\examples{
if (presto_has_default()) {
  db <- presto_default()
  print(dbListTables(db))
  dbDisconnect(db)
} else {
  message("No database connection.")
}
}
