% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_args_man}
\alias{get_args_man}
\title{Get GIS arguments and respective default values}
\usage{
get_args_man(alg = NULL, options = FALSE, qgis_env = set_env())
}
\arguments{
\item{alg}{The name of the algorithm for which one wishes to retrieve
arguments and default values.}

\item{options}{Sometimes one can choose between various options for a 
function argument. Setting option to \code{TRUE} will automatically assume 
one wishes to use the first option (default: \code{FALSE}).}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}
}
\value{
The function returns a list whose names correspond to the function 
  arguments one needs to specify. The list elements correspond to the argument
  specifications. The specified function arguments can serve as input for 
  \code{\link{run_qgis}}'s params argument. Please note that although 
  \code{get_args_man} tries to retrieve default values, one still needs to 
  specify some function arguments manually such as the input and the output 
  layer.
}
\description{
\code{get_args_man} retrieves automatically function arguments 
and respective default values for a given QGIS geoalgorithm.
}
\details{
\code{get_args_man} basically mimics the behavior of the QGIS GUI. 
  That means, for a given GIS algorithm, it captures automatically all 
  arguments and default values. In the case that a function argument has
  several options, one can indicate to use the first option (see also
  \code{\link{get_options}}), which is the QGIS GUI default behavior.
}
\note{
Please note that some default values can only be set after the user's 
  input. For instance, the GRASS region extent will be determined 
  automatically by \code{\link{run_qgis}} if left blank.
}
\examples{
\dontrun{
get_args_man(alg = "qgis:addfieldtoattributestable")
# and using the option argument
get_args_man(alg = "qgis:addfieldtoattributestable", options = TRUE)
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

