% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap.phylo.R
\name{swap.phylo}
\alias{swap.phylo}
\title{Test the effect of phylogenetic uncertainty on rate shifts found at a particular node}
\usage{
swap.phylo(tree,si=0.5,si2=0.5,node,y,rts,nrep=100,cov=NULL)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric or fully dichotomous.}

\item{si}{the proportion of tips whose topologic arrangement will be swapped.}

\item{si2}{the proportion of nodes whose age will be changed.}

\item{node}{the focal node to be tested.}

\item{y}{the phenotype under testing.}

\item{rts}{the rates found by \code{\link{RRphylo}} on the original tree.}

\item{nrep}{the number of simulated trees to be produced.}

\item{cov}{the covariate to be indicated if its effect on rate values must be accounted for. Contrary to \code{RRphylo}, \code{'cov'} needs to be as long as the number of tips of the tree.}
}
\value{
The function returns a 'list' object containing:

\strong{$p.swap} the probability that the rates at \code{'node'} are different from rates at the rest of the tree.

\strong{$rates} the distribution of rates per branch as calculated by \code{RRphylo} on 'swapped' phylogenies.
}
\description{
The function uses a number of alternative phylogenies with altered (as compared to the reference tree) topology and branch lengths tests whether the tips descending from the specified node (\code{'node'}) have statistically different rates from the rest of the tree. A phenotypic vector \code{'y'} must be supplied. Eventually, the effect of a covariate could be included.
}
\details{
\code{swap.phylo} changes the tree topology and branch lengths to a level specified by the user. Up to half of the tips, and half of the branch lengths can be changed randomly. The function provides a 'swapped' tree, yet, importantly, once a shift in the rate of evolution has been found by \code{\link{RRphylo}}, this function can be used to test whether the shift depends on the tree topology and branch lengths. It runs \code{RRphylo} on swapped trees (default is 100) and then calculates the absolute rate difference between all the branches of the shifted node and the rest of the tree. A t-test is eventually performed to assess significance.
}
\examples{
  data("DataApes")
  DataApes$PCstage->PCstage
  DataApes$Tstage->Tstage
  DataApes$CentroidSize->CS

\donttest{
# Case 1. swap.phylo without accounting for the effect of a covariate
  RRphylo(tree=Tstage,y=PCstage)->RR
  RR$rates->rr
  swap.phylo(Tstage,node=61,y=PCstage,rts=rr)
# Case 2. swap.phylo accounting for the effect of a covariate
  RRphylo(tree=Tstage,y=CS)->RRcova
  c(RRcova$aces,CS)->cov.values
  c(rownames(RRcova$aces),names(CS))->names(cov.values)
  RRphylo(tree=Tstage,y=PCstage,cov=cov.values)->RR
  RR$rates->rr
  swap.phylo(Tstage,node=61,y=PCstage,rts=rr,cov=CS)
}
}
