% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSim.R
\name{runSim}
\alias{runSim}
\title{Run CAT simulations}
\usage{
runSim(catConfig, testConfig, simConfig)
}
\arguments{
\item{catConfig}{an instance of the S4 class \code{CATConfig} for CAT 
configurations.}

\item{testConfig}{an instance of the S4 class \code{TestConfig} for test 
specification configuration.}

\item{simConfig}{an instance of the S4 class \code{SimConfig} for test 
specification configuration.}
}
\value{
the simulation result in the instance of \code{SimResult}.
}
\description{
\code{runSim} runs CAT simulations based on the provided configurations and 
returns the simulation result.
}
\details{
This function calls the Java helper method \code{org.act.util.RHelper.runSim}
via rJava to exceute CAT simulation.
}
\examples{
if(interactive()){
## Defines item attributes types
itemNumericColumn <- c(FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, 
  TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, 
  FALSE, TRUE, FALSE, TRUE, FALSE, FALSE,FALSE)

## Specifies the item pool file 
itemPoolCSVPath <- system.file("extdata", "itempool10Items.csv", 
  package = "RSCAT")

## Specifies the constraint table file   
constraintCSVPath <- system.file("extdata", "constraintSet1.csv", 
  package = "RSCAT")

## Configures solver parameters  
solverConfig <- SolverConfig(absGap = 1e-3, relGap = 1e-3, intTol = 1e-6)

## Configures the EAP estimaition 
eapConfig <- EAPConfig(numQuad = 6L, minQuad = -2, maxQuad = 2, 
  priorDistType = "Normal", distParams = c(0,1))
  
## Configures CAT   
catConfig <- CATConfig(solverConfig = solverConfig, 
  scoreMethodConfig = scoreMethodConfig(eapConfig), lValue = 3L)
  
## Configures test specifications   
testConfig <- TestConfig(testConfigID = "Test1", testLength = 6L, 
  itempoolPath = itemPoolCSVPath, constraintPath = constraintCSVPath, 
  itemNumericColumn = itemNumericColumn)

## Configures the simulation      
simConfig <- SimConfig(simID = "Sim1", numExaminees = 8L)

## Runs CAT simulation
simResult <- runSim(catConfig, testConfig, simConfig)
}
}
