% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_interval_umap.R
\name{sym.umap.symbolic_tbl}
\alias{sym.umap.symbolic_tbl}
\alias{sym.umap}
\title{UMAP for symbolic data tables}
\usage{
sym.umap(sym.data, config = umap::umap.defaults,
method = c("naive", "umap-learn"),preserve.seed = TRUE,...)
}
\arguments{
\item{sym.data}{symbolic data table}

\item{config}{object of class umap.config}

\item{method}{character, implementation. Available methods are 'naive' (an implementation written in pure R) and 'umap-learn' (requires python package 'umap-learn')}

\item{preserve.seed}{logical, leave TRUE to insulate external code from randomness within the umap algorithms; set FALSE to allow randomness used in umap algorithms to alter the external random-number generator}

\item{...}{list of settings; values overwrite defaults from config; see documentation of umap.default for details about available settings}
}
\description{
UMAP for symbolic data tables
}
\examples{
\dontrun{
res <- sym.umap(oils)
res
plot(res)
}
}
