% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSVM.R
\name{LinearTSVM}
\alias{LinearTSVM}
\title{Linear CCCP Transductive SVM classifier}
\usage{
LinearTSVM(X, y, X_u, C, Cstar, s = 0, x_center = FALSE, scale = FALSE,
  eps = 1e-06, verbose = FALSE, init = NULL)
}
\arguments{
\item{X}{matrix; Design matrix, intercept term is added within the function}

\item{y}{vector; Vector or factor with class assignments}

\item{X_u}{matrix; Design matrix of the unlabeled data, intercept term is added within the function}

\item{C}{numeric; Cost parameter of the SVM}

\item{Cstar}{numeric; Cost parameter of the unlabeled objects}

\item{s}{numeric; parameter controlling the loss function of the unlabeled objects}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{logical; If TRUE, apply a z-transform to all observations in X and X_u before running the regression}

\item{eps}{numeric; Convergence criterion}

\item{verbose}{logical; print debugging messages (default: FALSE)}

\item{init}{numeric; Initial classifier parameters to start the convex concave procedure}
}
\description{
Implementation for the Linear TSVM. This method is mostly for debugging purposes and does not allow for the balancing constraint or kernels, like the TSVM function.
}
\references{
Collobert, R. et al., 2006. Large scale transductive SVMs. Journal of Machine Learning Research, 7, pp.1687-1712.
}
\seealso{
Other RSSL classifiers: \code{\link{EMLinearDiscriminantClassifier}},
  \code{\link{GRFClassifier}},
  \code{\link{ICLeastSquaresClassifier}},
  \code{\link{ICLinearDiscriminantClassifier}},
  \code{\link{KernelLeastSquaresClassifier}},
  \code{\link{LaplacianKernelLeastSquaresClassifier}},
  \code{\link{LaplacianSVM}},
  \code{\link{LeastSquaresClassifier}},
  \code{\link{LinearDiscriminantClassifier}},
  \code{\link{LinearSVM}},
  \code{\link{LogisticLossClassifier}},
  \code{\link{LogisticRegression}},
  \code{\link{MCLinearDiscriminantClassifier}},
  \code{\link{MCNearestMeanClassifier}},
  \code{\link{MCPLDA}},
  \code{\link{MajorityClassClassifier}},
  \code{\link{NearestMeanClassifier}},
  \code{\link{QuadraticDiscriminantClassifier}},
  \code{\link{S4VM}}, \code{\link{SVM}},
  \code{\link{SelfLearning}}, \code{\link{TSVM}},
  \code{\link{USMLeastSquaresClassifier}},
  \code{\link{WellSVM}}, \code{\link{svmlin}}
}

