% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobMethods.R
\name{getJobs}
\alias{getJobs}
\title{Get Jobs}
\usage{
getJobs(account, username = Sys.getenv("SLUSER"), limit = 100L,
  getFullJobs = FALSE, skipJobs = 0L, to = NULL, from = NULL, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{limit}{Specifies the number of jobs to return. Default is 100 and max is 500.}

\item{getFullJobs}{Get full job information, rather than just IDs. Default is FALSE.}

\item{skipJobs}{Skips the specified number of jobs. Default is 0.}

\item{to}{Get jobs until the specified time (POSIXct)}

\item{from}{Get jobs since the specified time (POSIXct)}

\item{...}{Additonal function arguments - Currently unused.}
}
\value{
returns a named list. "data" is the job data minus the tags and custom-data.
tagsAndCD are a list of tags and custom-data for each job. If getFullJobs = FALSE then data only contains the job ids and
tagsAndCD contains empty lists for each job.
}
\description{
List recent jobs belonging to a specific user
}
\examples{
\dontrun{
myAcc <- account()
myJobs <- getJobs(myAcc)
#> myJobs$data[1,]
#id
#1: 4152e0a185f945bfa43e091eef1e7c30
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(id, browser)]
#id      browser
#1: 4152e0a185f945bfa43e091eef1e7c30 googlechrome
testId <- myJobs$data[1, id]

#> myJobs$data[1,.(build, passed)]
#build passed
#1:    24  FALSE

# update this job
updateJob(myAcc, jobID = testId, passed = TRUE, build = 20)
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(build, passed)]
#build passed
#1:    20   TRUE
# deleteJob(myAcc, jobID = testId)
stopJob(myAcc, jobID = testId)

jobAssets <- getJobAssetNames(myAcc, jobID = testId)
#> jobAssets[["selenium-log"]]
#[1] "selenium-server.log"

jobLog <- getJobAssetFiles(myAcc, jobID = testId)
# deleteJobAssets(myAcc, jobID = testId)
}

}
\seealso{
Other jobMethods: \code{\link{deleteJobAssets}},
  \code{\link{deleteJob}}, \code{\link{getJobAssetFiles}},
  \code{\link{getJobAssetNames}}, \code{\link{stopJob}},
  \code{\link{updateJob}}
}

