# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal function for running scelestial algorithm.
#'
#' @param data The data
#' @param minK,maxK Minimum and maximum number of vertices to be considered 
#'   for k-restricted Steiner tree.
#' @return The tree as well as missing value imputation
#' @export
.scelestial <- function(data, minK = 3L, maxK = 4L) {
    .Call('_RScelestial__scelestial', PACKAGE = 'RScelestial', data, minK, maxK)
}

#' Internal function for generating synthetic single-cell
#' data through simulation of tumor growth and evolution.
#'
#' @param sample Number of samples
#' @param site Number of sites
#' @param evolutionSteps Number of non-root nodes in the evolutionary tree 
#'   to be generated.
#' @param mutationRate The rate of mutation on each evolutionary step in evolutionary tree synthesis.
#' @param advantageIncreaseRatio,advantageDecreaseRatio,advantageKeepRatio A child node
#'   in the evolutionary tree is chosen for increase/decrease/keep its parent advantage with
#'   probabilities proportional to \code{advantage.increase.ratio}/\code{advantage.decrease.ratio}/\code{advantage.keep.ratio}.
#' @param advantageIncreaseStep,advantageDecreaseStep The amount of 
#'   increasing or decreasing the advantage of a cell relative to its parent.
#' @param mvRate Rate of missing value to be added to the resulting sequences.
#' @param fpRate,fnRate Rate of false positive (0 -> 1) and false negative (1 -> 0)
#'   in the sequences.
#' @param seed The seed for randomization.
#' @return The function returns a list. The list consists of 
#'   \itemize{
#'     \item \code{sequence}: A data frame representing
#'       result of sequencing. The data frame has a row for each locus and a column for each sample.
#'     \item \code{true.sequence}: The actual sequence for the sample before adding errors and missing values.
#'     \item \code{true.clone}: A list that stores index of sampled cells for each node in the evolutionary tree.
#'     \item \code{true.tree}: The evolutionary tree that the samples are sampled from. It is a data frame
#'       with \code{src}, \code{dest}, and \code{len} columns representing source, destination and weight of edges of the tree,
#'       respectively.
#'  }
#' 
#' @export
.synthesis <- function(sample, site, evolutionSteps, mutationRate = 0.01, advantageIncreaseRatio = 1, advantageDecreaseRatio = 10, advantageKeepRatio = 100, advantageIncreaseStep = 0.01, advantageDecreaseStep = 0.01, mvRate = 0.5, fpRate = 0.2, fnRate = 0.1, seed = -1L) {
    .Call('_RScelestial__synthesis', PACKAGE = 'RScelestial', sample, site, evolutionSteps, mutationRate, advantageIncreaseRatio, advantageDecreaseRatio, advantageKeepRatio, advantageIncreaseStep, advantageDecreaseStep, mvRate, fpRate, fnRate, seed)
}

