% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SCAuth}
\alias{SCAuth}
\title{Store Credentials for the Adobe Analytics API}
\usage{
SCAuth(key, secret, company = "", token.file = "", auth.method = "legacy",
  debug.mode = FALSE)
}
\arguments{
\item{key}{client id from your app in the Adobe Marketing cloud Dev Center OR if you are using auth.method='legacy', then this is the API username (username:company)}

\item{secret}{secret from your app in the Adobe Marketing cloud Dev Center OR if you are using auth.method='legacy', then this is the API shared secret}

\item{company}{your company (only required if using OAUTH2 AUTH method)}

\item{token.file}{if you would like to save your OAUTH token and other auth details for use in
future sessions, specify a file here. The method checks for the existence of the file and uses that if available.}

\item{auth.method}{defaults to legacy, can be set to 'OAUTH2' to use the newer OAUTH method.}

\item{debug.mode}{set global debug mode}
}
\value{
Global credentials list 'SC.Credentials'
}
\description{
SCAuth
}
\details{
Authorise and store credentials for the Adobe Analytics API
}
\examples{
\dontrun{
#Legacy authentication
SCAuth("key", "secret")

}
}

