% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackMeta.R
\name{stackMeta}
\alias{stackMeta}
\title{Import separate Landsat files into single stack}
\usage{
stackMeta(file, quantity = "all", category = "image", allResolutions = FALSE)
}
\arguments{
\item{file}{Character. Path to Landsat MTL metadata (*_MTL.txt) file or an Landsat CDR xml metadata file (*.xml).}

\item{quantity}{Character vector. Which quantity should be returned. Options: digital numbers ('dn'), top of atmosphere reflectance ('tre'), at surface reflectance ('sre'), brightness temperature ('bt'), spectral index ('index'), all quantities ('all').}

\item{category}{Character vector. Which category of data to return. Options 'image': image data, 'pan': panchromatic image, 'index': multiband indices, 'qa' quality flag bands, 'all': all categories.}

\item{allResolutions}{Logical. if \code{TRUE} a list will be returned with length = unique spatial resolutions.
This argument was introduced to maintain backward compatibility and will be switched to TRUE in an upcoming release. Please base all new code on terra.}
}
\value{
Returns one single SpatRaster comprising all requested bands.
If \code{allResolutions = TRUE} *and* there are different resolution layers (e.g. a 15m panchromatic band along wit 30m imagery) a list of RasterStacks will be returned.
}
\description{
Reads Landsat MTL or XML metadata files and loads single Landsat Tiffs into a rasterStack.
Be aware that by default stackMeta() does NOT import panchromatic bands nor thermal bands with resolutions != 30m.
}
\note{
Be aware that by default stackMeta() does NOT import panchromatic bands nor thermal bands with resolutions != 30m. Use the allResolutions argument to import all layers.
Note that nowadays the USGS uses cubic convolution to resample the TIR bands to 30m resolution.
}
\examples{
## Example metadata file (MTL)
mtlFile  <- system.file("external/landsat/LT52240631988227CUB02_MTL.txt", package="RStoolbox")

## Read metadata
metaData <- readMeta(mtlFile)
summary(metaData)

## Load rasters based on metadata file
lsat     <- stackMeta(mtlFile)
lsat
}
