% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_clean_deps}
\alias{prj_clean_deps}
\title{Uninstalls unused packages from the local project environment.}
\usage{
prj_clean_deps(prj = NULL)
}
\arguments{
\item{prj}{project to clean dependencies of. If not passed will use the project
base in the working directory. (type: rsuite_project, default: NULL)}
}
\description{
Checks if all dependencies installed are required by project packages or
master scripts and removes those which are not required any more.
}
\details{
Logs all messages from the building process onto the rsuite logger. Use \code{logging::setLevel}
to control logs verbosity. DEBUG level turns on building and downloading messages.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # add colorspace to master script
  master_script_fpath <- file.path(prj$path, "R", "master.R")
  write("library(colorspace)", file = master_script_fpath, append = TRUE)

  # install colorspace into project local environment
  prj_install_deps(prj = prj)

  # remove dependency to colorspace
  writeLines(head(readLines(master_script_fpath), n = -1),
             con = master_script_fpath)

  # uninstall colorspace from project local environment
  prj_clean_deps(prj = prj)
}

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_init}}, \code{\link{prj_install_deps}},
  \code{\link{prj_load}}, \code{\link{prj_lock_env}},
  \code{\link{prj_pack}}, \code{\link{prj_start_package}},
  \code{\link{prj_start}}, \code{\link{prj_unload}},
  \code{\link{prj_zip}}
}
