
library(RTDE)


#####
# (1) simulation

n <- 100
x <- dataRTDE(simu.nb=n, simu.marg="ufrechet", simu.cop="indep")
print(x)
summary(x)
plot(x, xlab="x", ylab="y")
plot(x, xlab="x", ylab="y", which=2)

n <- 100
y <- dataRTDE(simu.nb=n, simu.marg="ufrechet", simu.cop="indep", contamin.eps=1/100,
	contamin.method="max+", contamin.marg="ufrechet", contamin.cop="indep")
print(y)
summary(y)

plot(y, xlab="x", ylab="y")
legend("right", pch=21, col=c("black", "red"), leg=c("orig", "cont"))

plot(y, xlab="x", ylab="y", which=2)
legend("right", pch=21, col=c("black", "red"), leg=c("orig", "cont"))


#####
# (2) part of the workers' compensation dataset

x1 <- c(
  21.798086,  22.640528,  22.572010,  24.789710,  25.876764,  28.033613,
  22.525887,  12.004031,  12.713178,  13.596610,  14.811727,  12.774073,
  20.245789,  24.242468,  50.216515,  56.099793,  58.109747,  67.807105,
  73.852437,  84.208474,  83.604216,  19.507341,  20.810822,  23.838122,
  24.212193,  25.367578,  35.401344,  37.580989,  12.428727,  13.492474,
  13.303600,  13.228920,  14.060473,  15.227696,  17.857683,   6.829432,
   6.219655,   5.696577,   4.542884,   3.663628,   2.632086,   1.932376,
   3.724269,   4.149906,   3.696872,   0.487892,  0.594629,   0.560057,
   0.724571,   2.494260,   3.394857,  3.314038,  10.595191,  12.863955,
   2.789484,   2.426480,   3.140245,   3.964679,   4.899610,   5.247896,
   6.280799,   7.721616,   9.324806,  30.035148,  32.618878,  36.071278,
  42.494763,  49.524793,  48.872610,  40.636397, 211.719199, 232.681695,
 230.007534, 234.635378, 251.852677, 207.512194, 215.038202,  22.525133,
  23.545828,  24.979337,  27.390359,  27.337832,  28.268401,  25.281128,
  11.939588,  10.566079,  19.387104,  23.062327,  23.089131,  23.799825,
  21.317594,  28.171269,  32.008767,  31.300733,  33.507831,  32.207902,
  23.471988,  24.101833,  24.766193,  26.078216)

x2 <- c(
 0.538707, 0.439184, 1.059775, 0.560013, 1.004997, 1.097314, 0.609833, 0.270222,
 0.229566, 0.596850, 0.196539, 0.134248, 0.489312, 0.418218, 0.769208, 0.649707,
 0.503919, 0.675466, 0.545745, 1.562266, 0.931762, 0.291125, 0.499927, 0.151084,
 0.141910, 0.300373, 0.119761, 0.141300, 0.377662, 0.169574, 0.243585, 0.061215,
 0.055272, 0.312816, 0.160196, 0.623029, 0.280707, 0.174422, 0.176666, 0.153907,
 0.101874, 0.000000, 0.000000, 0.018082, 0.408802, 0.010500, 0.000000, 0.000000,
 0.037500, 0.011234, 0.042146, 0.086599, 0.041500, 0.115592, 0.000000, 0.170623,
 0.078436, 0.047501, 0.051499, 0.144621, 0.008998, 0.259875, 0.548369, 0.383658,
 0.420764, 0.588094, 0.717523, 1.133547, 1.372065, 0.601273, 2.140846, 2.382040,
 2.929906, 3.165114, 3.595126, 4.284873, 2.739517, 0.389158, 0.374650, 0.684493,
 0.143933, 1.236701, 0.734178, 0.850133, 0.348156, 0.331977, 0.116060, 0.266805,
 0.310604, 0.278189, 0.079680, 1.238292, 0.576512, 0.831404, 1.303705, 0.673907,
 0.605122, 0.664457, 0.348918, 0.370878)

obs <- dataRTDE(cbind(x1, x2))
obs
summary(obs)

plot(obs)

obs <- dataRTDE(cbind(x1, x2), contamin.eps=2/100,
	contamin.method="max+", contamin.marg="ufrechet", contamin.cop="indep")
obs
summary(obs)

plot(obs)

plot(obs, which=2)