% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/advector.R, R/methods.R
\name{ADvector}
\alias{ADvector}
\alias{advector}
\alias{Ops.advector}
\alias{Math.advector}
\alias{as.vector.advector}
\alias{as.complex.advector}
\alias{aperm.advector}
\alias{c.advector}
\alias{[.advector}
\alias{[<-.advector}
\alias{[[.advector}
\alias{rep.advector}
\alias{sum.advector}
\alias{mean.advector}
\alias{prod.advector}
\alias{is.numeric.advector}
\alias{as.double.advector}
\alias{Complex.advector}
\alias{Summary.advector}
\alias{diff.advector}
\alias{print.advector}
\alias{ifelse,num,ad,ad-method}
\alias{ifelse,num,num,num-method}
\alias{outer,advector,advector,missing-method}
\title{The AD vector and its methods}
\usage{
advector(x)

\method{Ops}{advector}(e1, e2)

\method{Math}{advector}(x, ...)

\method{as.vector}{advector}(x, mode = "any")

\method{as.complex}{advector}(x, ...)

\method{aperm}{advector}(a, perm, ...)

\method{c}{advector}(...)

\method{[}{advector}(x, ...)

\method{[}{advector}(x, ...) <- value

\method{[[}{advector}(x, ...)

\method{rep}{advector}(x, ...)

\method{sum}{advector}(x, ..., na.rm = FALSE)

\method{mean}{advector}(x, ...)

\method{prod}{advector}(x, ..., na.rm)

\method{is.numeric}{advector}(x)

\method{as.double}{advector}(x, ...)

\method{Complex}{advector}(z)

\method{Summary}{advector}(..., na.rm = FALSE)

\method{diff}{advector}(x, lag = 1L, differences = 1L, ...)

\method{print}{advector}(x, ...)

\S4method{ifelse}{num,ad,ad}(test, yes, no)

\S4method{ifelse}{num,num,num}(test, yes, no)

\S4method{outer}{advector,advector,missing}(X, Y)
}
\arguments{
\item{x}{numeric or advector}

\item{e1}{advector}

\item{e2}{advector}

\item{...}{Additional arguments}

\item{mode}{FIXME might not be handled correctly by \code{as.vector}}

\item{a}{advector with dimension attribute}

\item{perm}{Permutation as in \code{aperm}}

\item{value}{Replacement value implicitly converted to AD}

\item{na.rm}{Must be FALSE (default)}

\item{z}{Complex (not allowed)}

\item{lag}{As \link[base]{diff}}

\item{differences}{As \link[base]{diff}}

\item{test}{\code{logical} vector}

\item{yes}{\code{advector}}

\item{no}{\code{advector}}

\item{X}{As \link[base]{outer}}

\item{Y}{As \link[base]{outer}}
}
\value{
Object of class \code{"advector"}.
}
\description{
An \code{advector} is a class used behind the scenes to replace
normal R numeric objects during automatic differentiation. An
\code{advector} has a 'temporary lifetime' and therefore you do not
\emph{see} / \emph{need to know} it as a normal user.
}
\details{
An AD vector (class='advector') is an atomic R vector of 'codes'
that are internally interpretable as 'AD scalars'. A substantial
part of R's existing S3 matrix and array functionality can be
re-used for AD vectors.
}
\section{Functions}{
\itemize{
\item \code{advector()}: Construct a new advector

\item \code{Ops(advector)}: Binary operations

\item \code{Math(advector)}: Unary operations

\item \code{as.vector(advector)}: Makes \code{array(x)} work.

\item \code{as.complex(advector)}: Convert to \link{ADcomplex}. Note that dimensions are dropped for consistency with base R.

\item \code{aperm(advector)}: Equivalent of \link[base]{aperm}

\item \code{c(advector)}: Equivalent of \link[base]{c}. However note the limitation for mixed types: If \code{x} is an AD type, \code{c(x,1)} works while \code{c(1,x)} does not!

\item \code{[}: Equivalent of \link[base]{[}

\item \code{`[`(advector) <- value}: Equivalent of \link[base]{[<-}

\item \code{[[}: Equivalent of \link[base]{[[}

\item \code{rep(advector)}: Equivalent of \link[base]{rep}. Makes \code{outer(x,x,...)} work.

\item \code{sum(advector)}: Equivalent of \link[base]{sum}. \code{na.rm=TRUE} is allowed, but note that this feature assumes correct propagation of NAs via C-level arithmetic.

\item \code{mean(advector)}: Equivalent of \link[base]{mean} except no arguments beyond \code{x} are supported.

\item \code{prod(advector)}: Equivalent of \link[base]{prod} except \code{na.rm} not allowed.

\item \code{is.numeric(advector)}: Makes \code{cov2cor()} work. FIXME: Any unwanted side-effects with this?

\item \code{as.double(advector)}: Makes \code{as.numeric()} work.

\item \code{Complex(advector)}: \link{Complex} operations are not allowed and will throw an error.

\item \code{Summary(advector)}: Non differentiable \link{Summary} operations (e.g. \code{min} \code{max}) are not allowed and will throw an error.

\item \code{diff(advector)}: Equivalent of \link[base]{diff}

\item \code{print(advector)}: Print method

\item \code{ifelse(test = num, yes = ad, no = ad)}: Equivalent of \link[base]{ifelse}

\item \code{ifelse(test = num, yes = num, no = num)}: Default method

\item \code{outer(X = advector, Y = advector, FUN = missing)}: Equivalent of \link[base]{outer}

}}
\examples{
x <- advector(1:9)
a <- array(x, c(3,3))  ## as an array
outer(x, x, "+") ## Implicit via 'rep'
rev(x)           ## Implicit via '['
}
