\name{create_precisionRecallSummary}
\alias{create_precisionRecallSummary}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates a summary with precision, recall, and F1 scores.
}
\description{
Creates a summary with precision, recall, and F1 scores for each algorithm broken down by unique label.
}
\usage{
create_precisionRecallSummary(corpus, classification_results, b_value = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_corpus}} function.
}
  \item{classification_results}{
A \code{cbind()} of result objects returned by \code{\link{classify_model}}, or the object returned by \code{\link{classify_models}}.
}
  \item{b_value}{
b-value for generating precision, recall, and F-scores statistics.
}
}
\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}
\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(corpus, algorithms=c("MAXENT","SVM"))
results <- classify_models(corpus, models)
precision_recall_f1 <- create_precisionRecallSummary(corpus, results)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{method}
