% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast_svm.R
\name{transForecast_svm}
\alias{transForecast_svm}
\title{Forecast - using Support Vector Machines}
\usage{
transForecast_svm(transData, histData, predData_svm, startDate, endDate,
                    depVar, indVars,  ratingCat, pct, tuning, kernelType, cost,
                    cost.weights, gamma, gamma.weights)
}
\arguments{
\item{transData}{aggregate transition matrix data.}

\item{histData}{historical macroeconomic,financial and non-financial data.}

\item{predData_svm}{forecasting data.}

\item{startDate}{start date of the estimation time window, in string or numeric format.}

\item{endDate}{end date of the estimation time window, in string or numeric format.}

\item{depVar}{dependent variable, as a string.}

\item{indVars}{list containing the independent variables.}

\item{ratingCat}{list containing the unique rating caetgories}

\item{pct}{percent of data used in training dataset.}

\item{tuning}{perform tuning. If tuning='TRUE' tuning is perform. If tuning='FALSE' tuning is not performed}

\item{kernelType}{the kernel used in training and predicting (see Package e1071 for more detail)}

\item{cost}{cost of constraints violation (default: 1) it is the 'C' constant of the regularization term in the Lagrange formulation.}

\item{cost.weights}{vector containing tuning parameters for cost}

\item{gamma}{parameter needed for all kernels except linear (default: 1/(data dimension))}

\item{gamma.weights}{vector containing tuning parameters for gamma}
}
\value{
The output consists of a forecasted transition matrix.
}
\description{
This model implements a forecasting method using Support Vector Machines.
}
\examples{
startDate <- as.Date("1990-01-01")
endDate <- as.Date("2005-01-01")
depVar <- c("end_rating")
indVars <-c("Macro1", "Financial1","Industry1")
pct <- 0.8
wgt <-  "mCount"
ratingCat <- c("A","B", "C", "D", "E", "F", "G", "N")
lstCategoricalVars <- c("end_rating")
tuning <- "TRUE"
cost <- 100
gamma <- .1
cost.weights <- c(0.1, 10, 100)
gamma.weights <- c(0.01, 0.25, 0.5, 1)
kernelType <- "radial"

\dontrun{
transData <- expandTransData(df,wgt)
}
\dontrun{
svm_T<-transForecast_svm(transData, histData, predData_svm,  startDate, endDate,
       depVar,indVars,  ratingCat, pct, tuning, kernelType,cost, cost.weights,
       gamma, gamma.weights)
}

}
\author{
Abdoulaye (Ab) N'Diaye
}
