% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast_ann.R
\name{transForecast_ann}
\alias{transForecast_ann}
\title{Forecast - using Artificial Neural Networks}
\usage{
transForecast_ann(data, histData, predData_ann, startDate, endDate,
                    method, interval, snapshots, defind, depVar, indVars,  ratingCat, 
                    pct, hiddenlayers,activation,stepMax,rept, calibration)
}
\arguments{
\item{data}{a table containing historical credit ratings data (i.e., credit migration data). A dataframe of size \emph{nRecords} x 3 where each row contains an ID (column 1), a date (column 2), and a credit rating (column 3); The credit rating is the rating assigned to the corresponding ID on the corresponding date.}

\item{histData}{historical macroeconomic,financial and non-financial data.}

\item{predData_ann}{forecasting data.}

\item{startDate}{start date of the estimation time window, in string or numeric format.}

\item{endDate}{end date of the estimation time window, in string or numeric format.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{defind}{Default Indicator}

\item{depVar}{dependent variable, as a string.}

\item{indVars}{list containing the independent variables.}

\item{ratingCat}{list containing the unique rating caetgories}

\item{pct}{percent of data used in training dataset.}

\item{hiddenlayers}{a vector of integers specifying the number of hidden neurons (vertices) in each layer.}

\item{activation}{activation function. strings, 'logistic' and 'tanh' are possible for the logistic function and tangent hyperbolicus}

\item{stepMax}{the maximum steps for the training of the neural network. Reaching this maximum leads to a stop of the neural network's training process.}

\item{rept}{the number of repetitions for the neural network's training.}

\item{calibration}{determines if code uses the caret package to find optimal parameter. 'Yes' and 'No'}
}
\value{
The output consists of a forecasted transition matrix using ANN.
}
\description{
This model implements a forecasting method using Artificial Neural Networks.
}
\examples{
\dontrun{
library(dplyr)
library(plyr)
library(Matrix)


for (i in c(24, 25, 26, 27)) {
  data <- data
  
  histData <- histData.normz
  names(histData)[names(histData) == 'X3.month.Treasury.rate.normz.Lag.Q4'] <-
    'T3.month.Treasury.rate.normz.Lag.Q4'
  
  
  predData_ann2 <- predData_ann
  predData_ann2 <- subset(
    predData_ann2,
    X == i,
    select = c(
      X3.month.Treasury.rate.normz.Lag.Q4,
      Unemployment.....normz.YoY.AbsChng.Lag.Q2,
      GDP.Level..Bil...2009..normz.QoQ.AbsChng.Lag.Q2
    )
  )
  indVars   = c(
    "T3.month.Treasury.rate.normz.Lag.Q4",
    "Unemployment.....normz.YoY.AbsChng.Lag.Q2",
    "GDP.Level..Bil...2009..normz.QoQ.AbsChng.Lag.Q2"
  )
  names(predData_ann2)[names(predData_ann2) == 'X3.month.Treasury.rate.normz.Lag.Q4'] <-
    'T3.month.Treasury.rate.normz.Lag.Q4'
  
  
  startDate = "1991-08-16"
  endDate   = "2007-08-16"
  
  
  depVar <- c("end_rating")
  
  pct <- 1
  wgt <-  "mCount"
  ratingCat <- c("A", "B", "C", "D", "E", "F", "G")
  defind    <- "G"
  
  
  ratingCat <- as.numeric(factor(
    ratingCat,
    levels = c('A', 'B', 'C', 'D', 'E', 'F', 'G'),
    labels = c(1, 2, 3, 4, 5, 6, 7)
  ))
  defind <- as.numeric(factor(
    defind,
    levels = c('A', 'B', 'C', 'D', 'E', 'F', 'G'),
    labels = c(1, 2, 3, 4, 5, 6, 7)
  ))
  
  method    = "cohort"
  snapshots = 1
  interval  = 1
  hiddenlayers = c(1)
  activation = "logistic"
  stepMax = 1e9                #increase to make sure the DNN converges
  calibration = "FALSE"
  
  ann_TM <-
    transForecast_ann(
      data,
      histData,
      predData_ann2,
      startDate,
      endDate,
      method,
      interval,
      snapshots,
      defind,
      depVar,
      indVars,
      ratingCat,
      pct,
      hiddenlayers,
      activation,
      stepMax,
      calibration
    )
  print(ann_TM)
  
}
}

}
\author{
Abdoulaye (Ab) N'Diaye
}
