% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qq.R
\name{plot_qq}
\alias{plot_qq}
\title{Plot qqplot}
\usage{
plot_qq(
  data = data,
  comp.names = NULL,
  p.value.flag = "P.Value",
  ci = 0.95,
  plot.save.to = NULL
)
}
\arguments{
\item{data}{Summary statistics table or a list that contains multiple summary statistics tables from limma or DEseq2, where each row is a gene.}

\item{comp.names}{A character vector that contains the comparison names which correspond to the same order as \code{data}. No default.}

\item{p.value.flag}{The column name of \code{P-VALUE} (NOT FDR, NO multiplicity adjusted p-value) in the summary statistics table. Default = "P.Value".}

\item{ci}{Confidence interval. Default = 0.95}

\item{plot.save.to}{The file name and the address where to save the qq-plot "~/address_to_folder/qqplot.png". Default = NULL.}
}
\value{
The function return a ggplot object of qqplot
}
\description{
This function generates a QQ-plot object with confidence interval from summary statistics table generated by differential expression analysis
like \code{limma} or \code{DESeq2}.
}
\details{
The function produces the qqplot to evaluate the result from differential expression analysis. The output is a ggplot object.
}
\examples{
plot_qq(data = Sample_summary_statistics_table)
plot_qq(data = list(Sample_summary_statistics_table, Sample_summary_statistics_table1),
        comp.names = c("A","B"))

}
\references{
Xingpeng Li & Tatiana Gelaf Romer & Olya Besedina, RVA - RNAseq Visualization Automation tool.
}
