% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf_aggregate.R, R/rw_scen_aggregate.R
\name{rdf_aggregate}
\alias{rdf_aggregate}
\alias{rw_scen_aggregate}
\title{Aggregate RiverWare output for one or more scenarios}
\usage{
rdf_aggregate(agg, rdf_dir = ".", scenario = NULL, keep_cols = FALSE,
  nans_are = "0", find_all_slots = TRUE, cpp = TRUE, verbose = TRUE)

rw_scen_aggregate(scenarios, agg, scen_dir = ".", nans_are = "0",
  keep_cols = FALSE, file = NULL, scen_names = NULL,
  find_all_slots = TRUE, cpp = TRUE, verbose = TRUE)
}
\arguments{
\item{agg}{A \link{rwd_agg} object specifying the rdfs, slots, and
aggregation methods to use.}

\item{rdf_dir}{The top level directory that contains the rdf files. See
\strong{Directory Structure}.}

\item{scenario}{An optional parameter, that if it is not \code{NULL} or \code{NA}
(default) will be added to the tibble as another variable. Coerced to a
character if it is not already a character.}

\item{keep_cols}{Either boolean, or a character vector of column names to
keep in the returned tibble. The values of \code{keep_cols} work as follows:
\itemize{
\item \code{FALSE} (default) only includes the defaults columns:
\code{TraceNumber}, \code{ObjectSlot}, and \code{Value}. \code{Scenario} is also returned if
\code{scenario} is specified.
\item \code{TRUE}, all columns are returned.
\item A character vector, e.g., \code{c("ObjectName", "Units")}, allows the user to
include other columns that are not always required, in addition to the
"default" set of columns. If any of the values in \code{keep_cols} are not
found, a warning will post, but all other columns will be returned.
}}

\item{nans_are}{Either "0" or "error". If "0", then \code{NaN}s in the rwtbl are
treated as 0s. If "error", then any \code{NaN}s will cause an error in this
function.}

\item{find_all_slots}{Boolean; if \code{TRUE} (default), then the function will
abort if it cannot find a particular slot. If \code{FALSE}, then the function
will continue, even if a slot cannot be found. If a slot is not found,
then the function will return \code{-99} for the Trace, and \code{NaN} for Year, and
Value.}

\item{cpp}{Boolean; if \code{TRUE} (default), then use \link{rdf_to_rwtbl2}, which
relies on C++, otherwise, use original \link{rdf_to_rwtbl} function.}

\item{verbose}{Boolean; if \code{TRUE} (default), then print out status of
processing the scenario(s) and the slots in each scenario.}

\item{scenarios}{A character vector of scenario foders. This is usually a
vector of folder names, where each folder name contains one scenario worth
of data. \code{scenarios} can be named or unnamed. The names are used as the
scenario name in the returned \code{tbl_df}. Scenario names can also be
specified through the \code{scen_names} argument. If \code{scen_names} is specified,
\code{scenarios} should not already have names. If \code{scen_names} is not specified
and, \code{scenarios} is not already named, then the scenario folders will also
be used as the scenario names. See \strong{Directory Structure}.}

\item{scen_dir}{File path to the directory that contains the scenario
folders. \strong{Directory Structure}.}

\item{file}{Optionally save the \code{tbl_df} of aggregated scenario data as a
.txt, .csv, or .feather file. If \code{file} is specified, then the data are
saved in the specified output format.}

\item{scen_names}{An alternative way to specify scenario names.}
}
\value{
A \code{tbl_df} containing all aggregated and summarized data for all of
the specified \code{scenarios}.
}
\description{
Process the user specified \code{rwd_agg} object for one or more scenarios to
aggregate and summarize RiverWare output data.
}
\details{
\code{rdf_aggregate()} aggregates a single scenario of data by processing a
\link{rwd_agg} object.

In both cases, the user specifies the \link{rwd_agg}, which
determines the slots that are aggregated, and how they are aggregated. See
\link{rwd_agg} for more details on how it should be specified.

See the \strong{Directory Structure} section for how to specify \code{scenarios},
\code{scen_dir}, and \code{rdf_dir}.

\code{rw_scen_aggregate()} aggregates multiple scenarios of data. It processes the
\link{rwd_agg} object (\code{agg}) for each single scenario, and then binds all of the
individual scenario data together into a single \code{tbl_df}.
}
\section{Directory Structure}{


RiverWare and RiverSMART typically write data into an expected directory
structure. The below shows an example directory structure and corresponding
variable names for \code{rw_scen_aggregate()} and \code{rdf_aggregate()}. (In the
example below, C:/user/crss/CRSS.Jan2017/Scenario is the more complete
directory setup for the data included in \code{system.file("extdata/Scenario/")}.)

\preformatted{
C:/user/crss
|
|- CRSS.Jan2017
|    - model
|    - ruleset
|    - Scenario
|         - ISM1988_2014,2007Dems,IG,Most
|         - ISM1988_2014,2007Dems,IG,2002 
|    - ...
|- CRSS.Jan2018
|    - model
|    - ... (same general setup as CRSS.Jan2017)
}

To get one scenario's data, \code{rdf_aggregate()} can be called with \code{rdf_dir}
set to "C:/user/crss/CRSS.Jan2017/Scenario/ISM1988_2014,2007Dems,IG,Most".
(\code{scenario} can optionally be specified to git a scenario name.)

To aggregate multiple scenarios of data together, \code{rw_scen_aggregate()}
should be called with \code{scen_dir} set to "C:/user/CRSS/CRSS.Jan2017/Scenario"
and \code{scenarios} set to
\code{c("ISM1988_2014,2007Dems,IG,Most", "ISM1988_2014,2007Dems,IG,2002")}.
(Optionally, \code{scenarios} can be named, or \code{scen_names} specified to use
scenario names that are different from the above scenario folders.)

Finally, to aggregate scenario data from both CRSS.Jan2017 and CRSS.Jan2018,
\code{rw_scen_aggregate()} should be called with \code{scen_dir} set to
"C:/users/crss/". \code{scenarios} can then be set to
\code{c("CRSS.Jan2017/Scenario/ISM1988_2014,2007Dems,IG,Most","CRSS.Jan2018/Scenario/ISM1988_2014,2007Dems,IG,Most")},
assuming the same scenario exists in both folders. In this case it is
advisable to also specify \code{scen_names} or name \code{scenarios}.
}

\examples{
# rdf_aggregate() ----------

rdfPath <- system.file(
  "extdata/Scenario/ISM1988_2014,2007Dems,IG,Most", 
  package = "RWDataPlyr"
)

rwa <- rwd_agg(read.csv(
  system.file(
    "extdata/rwd_agg_files/passing_aggs.csv", 
    package = "RWDataPlyr"
  ), 
 stringsAsFactors = FALSE
))

x <- rdf_aggregate(rwa[1,], rdf_dir = rdfPath, scenario = "Most")

# rw_scen_aggregate() ----------

scens <- c("ISM1988_2014,2007Dems,IG,2002", "ISM1988_2014,2007Dems,IG,Most")
scenNames <- c("2002", "Most")
namedScens <- scens
names(namedScens) <- scenNames

scenPath <- system.file("extdata/Scenario", package = "RWDataPlyr")

rwa <- rwd_agg(read.csv(
  system.file(
    "extdata/rwd_agg_files/passing_aggs.csv", 
    package = "RWDataPlyr"
  ), 
 stringsAsFactors = FALSE
))

x <- rw_scen_aggregate(namedScens, agg = rwa[1,], scen_dir = scenPath)

# y will be identical to x

y <- rw_scen_aggregate(
  scens, 
  agg = rwa[1,], 
  scen_dir = scenPath, 
  scen_names = scenNames
)

identical(x, y) # is TRUE

}
