/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class K2
extends GlobalScoreSearchAlgorithm {
    boolean m_bRandomOrder = false;

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        int n;
        int n2;
        super.buildStructure(bayesNet, instances);
        int[] nArray = new int[instances.numAttributes()];
        nArray[0] = instances.classIndex();
        int n3 = 0;
        for (int i = 1; i < instances.numAttributes(); ++i) {
            if (n3 == instances.classIndex()) {
                // empty if block
            }
            int n4 = ++n3;
            ++n3;
            nArray[i] = n4;
        }
        if (this.m_bRandomOrder) {
            Random random = new Random();
            int n5 = this.getInitAsNaiveBayes() ? 0 : -1;
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                n = Math.abs(random.nextInt()) % instances.numAttributes();
                if (n2 == n5 || n == n5) continue;
                int n6 = nArray[n2];
                nArray[n2] = nArray[n];
                nArray[n] = n6;
            }
        }
        double d = this.calcScore(bayesNet);
        for (n2 = 1; n2 < instances.numAttributes(); ++n2) {
            boolean bl;
            n = nArray[n2];
            double d2 = d;
            boolean bl2 = bl = bayesNet.getParentSet(n).getNrOfParents() < this.getMaxNrOfParents();
            while (bl && bayesNet.getParentSet(n).getNrOfParents() < this.getMaxNrOfParents()) {
                int n7 = -1;
                for (int i = 0; i < n2; ++i) {
                    int n8 = nArray[i];
                    double d3 = this.calcScoreWithExtraParent(n, n8);
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    n7 = n8;
                }
                if (n7 != -1) {
                    bayesNet.getParentSet(n).addParent(n7, instances);
                    d = d2;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
    }

    public void setMaxNrOfParents(int n) {
        this.m_nMaxNrOfParents = n;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public void setInitAsNaiveBayes(boolean bl) {
        this.m_bInitAsNaiveBayes = bl;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public void setRandomOrder(boolean bl) {
        this.m_bRandomOrder = bl;
    }

    public boolean getRandomOrder() {
        return this.m_bRandomOrder;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(0);
        vector.addElement(new Option("\tInitial structure is empty (instead of Naive Bayes)\n", "N", 0, "-N"));
        vector.addElement(new Option("\tMaximum number of parents\n", "P", 1, "-P <nr of parents>"));
        vector.addElement(new Option("\tRandom order.\n\t(default false)", "R", 0, "-R"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setRandomOrder(Utils.getFlag('R', stringArray));
        this.m_bInitAsNaiveBayes = !Utils.getFlag('N', stringArray);
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(string));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[4 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.m_nMaxNrOfParents;
        if (!this.m_bInitAsNaiveBayes) {
            stringArray2[n++] = "-N";
        }
        if (this.getRandomOrder()) {
            stringArray2[n++] = "-R";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String randomOrderTipText() {
        return "When set to true, the order of the nodes in the network is random. Default random order is false and the order of the nodes in the dataset is used. In any case, when the network was initialized as Naive Bayes Network, the class variable is first in the ordering though.";
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a hill climbing algorithm restricted by an order on the variables";
    }
}

