/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class VFI
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected Instances m_Instances = null;
    protected double[][][] m_counts;
    protected double[] m_globalCounts;
    protected double[][] m_intervalBounds;
    protected double m_maxEntrop;
    protected boolean m_weightByConfidence = true;
    protected double m_bias = -0.6;
    private double TINY = 1.0E-11;

    public String globalInfo() {
        return "Classification by voting feature intervals. Intervals are constucted around each class for each attribute (basically discretization). Class counts are recorded for each interval on each attribute. Classification is by voting. For more info see Demiroz, G. and Guvenir, A. (1997) \"Classification by voting feature intervals\", ECML-97.\n\nHave added a simple attribute weighting scheme. Higher weight is assigned to more confident intervals, where confidence is a function of entropy:\nweight (att_i) = (entropy of class distrib att_i / max uncertainty)^-bias";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tDon't weight voting intervals by confidence", "C", 0, "-C"));
        vector.addElement(new Option("\tSet exponential bias towards confident intervals\n\t(default = 1.0)", "B", 1, "-B <bias>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setWeightByConfidence(!Utils.getFlag('C', stringArray));
        String string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            Double d = new Double(string);
            this.setBias(d);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String weightByConfidenceTipText() {
        return "Weight feature intervals by confidence";
    }

    public void setWeightByConfidence(boolean bl) {
        this.m_weightByConfidence = bl;
    }

    public boolean getWeightByConfidence() {
        return this.m_weightByConfidence;
    }

    public String biasTipText() {
        return "Strength of bias towards more confident features";
    }

    public void setBias(double d) {
        this.m_bias = -d;
    }

    public double getBias() {
        return -this.m_bias;
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (!this.getWeightByConfidence()) {
            stringArray[n++] = "-C";
        }
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getBias();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        int n3;
        if (!this.m_weightByConfidence) {
            this.TINY = 0.0;
        }
        if (instances.classIndex() == -1) {
            throw new Exception("No class attribute assigned");
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("VFI: class attribute needs to be nominal!");
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_ClassIndex = instances.classIndex();
        this.m_NumClasses = instances.numClasses();
        this.m_globalCounts = new double[this.m_NumClasses];
        this.m_maxEntrop = Math.log(this.m_NumClasses) / Math.log(2.0);
        this.m_Instances = new Instances(instances, 0);
        this.m_intervalBounds = new double[instances.numAttributes()][2 + 2 * this.m_NumClasses];
        for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
            n2 = 0;
            for (int i = 0; i < this.m_NumClasses * 2 + 2; ++i) {
                if (i == 0) {
                    this.m_intervalBounds[n3][i] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                if (i == this.m_NumClasses * 2 + 1) {
                    this.m_intervalBounds[n3][i] = Double.POSITIVE_INFINITY;
                    continue;
                }
                if (n2 != 0) {
                    this.m_intervalBounds[n3][i] = Double.NEGATIVE_INFINITY;
                    n2 = 0;
                    continue;
                }
                this.m_intervalBounds[n3][i] = Double.POSITIVE_INFINITY;
                n2 = 1;
            }
        }
        for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
            if (n3 == this.m_ClassIndex || !instances.attribute(n3).isNumeric()) continue;
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                Instance instance = instances.instance(n2);
                if (instance.isMissing(n3)) continue;
                if (instance.value(n3) < this.m_intervalBounds[n3][(int)instance.classValue() * 2 + 1]) {
                    this.m_intervalBounds[n3][(int)instance.classValue() * 2 + 1] = instance.value(n3);
                }
                if (!(instance.value(n3) > this.m_intervalBounds[n3][(int)instance.classValue() * 2 + 2])) continue;
                this.m_intervalBounds[n3][(int)instance.classValue() * 2 + 2] = instance.value(n3);
            }
        }
        this.m_counts = new double[instances.numAttributes()][][];
        for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
            if (instances.attribute(n3).isNumeric()) {
                int[] nArray = Utils.sort(this.m_intervalBounds[n3]);
                n = 1;
                for (int i = 1; i < nArray.length; ++i) {
                    if (this.m_intervalBounds[n3][nArray[i]] == this.m_intervalBounds[n3][nArray[i - 1]]) continue;
                    ++n;
                }
                double[] dArray = new double[n];
                n = 1;
                dArray[0] = this.m_intervalBounds[n3][nArray[0]];
                for (int i = 1; i < nArray.length; ++i) {
                    if (this.m_intervalBounds[n3][nArray[i]] == this.m_intervalBounds[n3][nArray[i - 1]]) continue;
                    dArray[n] = this.m_intervalBounds[n3][nArray[i]];
                    ++n;
                }
                this.m_intervalBounds[n3] = dArray;
                this.m_counts[n3] = new double[n][this.m_NumClasses];
                continue;
            }
            if (n3 == this.m_ClassIndex) continue;
            this.m_counts[n3] = new double[instances.attribute(n3).numValues()][this.m_NumClasses];
        }
        for (n3 = 0; n3 < instances.numInstances(); ++n3) {
            Instance instance = instances.instance(n3);
            int n4 = (int)instances.instance(n3).classValue();
            this.m_globalCounts[n4] = this.m_globalCounts[n4] + instance.weight();
            block8: for (n = 0; n < instances.numAttributes(); ++n) {
                if (instance.isMissing(n) || n == this.m_ClassIndex) continue;
                if (instances.attribute(n).isNumeric()) {
                    double d = instance.value(n);
                    boolean bl = false;
                    for (int i = this.m_intervalBounds[n].length - 1; i >= 0; --i) {
                        if (d > this.m_intervalBounds[n][i]) {
                            bl = true;
                            double[] dArray = this.m_counts[n][i];
                            int n5 = (int)instance.classValue();
                            dArray[n5] = dArray[n5] + instance.weight();
                            continue block8;
                        }
                        if (d != this.m_intervalBounds[n][i]) continue;
                        bl = true;
                        double[] dArray = this.m_counts[n][i];
                        int n6 = (int)instance.classValue();
                        dArray[n6] = dArray[n6] + instance.weight() / 2.0;
                        double[] dArray2 = this.m_counts[n][i - 1];
                        int n7 = (int)instance.classValue();
                        dArray2[n7] = dArray2[n7] + instance.weight() / 2.0;
                        continue block8;
                    }
                    continue;
                }
                double[] dArray = this.m_counts[n][(int)instance.value(n)];
                int n8 = (int)instance.classValue();
                dArray[n8] = dArray[n8] + instance.weight();
            }
        }
    }

    public String toString() {
        if (this.m_Instances == null) {
            return "FVI: Classifier not built yet!";
        }
        StringBuffer stringBuffer = new StringBuffer("Voting feature intervals classifier\n");
        return stringBuffer.toString();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.m_NumClasses];
        double[] dArray2 = new double[this.m_NumClasses];
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            int n;
            double d3;
            int n2;
            if (i == this.m_ClassIndex || instance.isMissing(i)) continue;
            double d4 = instance.value(i);
            boolean bl = false;
            if (instance.attribute(i).isNumeric()) {
                for (n2 = this.m_intervalBounds[i].length - 1; n2 >= 0; --n2) {
                    int n3;
                    if (d4 > this.m_intervalBounds[i][n2]) {
                        for (n3 = 0; n3 < this.m_NumClasses; ++n3) {
                            if (!(this.m_globalCounts[n3] > 0.0)) continue;
                            dArray2[n3] = (this.m_counts[i][n2][n3] + this.TINY) / (this.m_globalCounts[n3] + this.TINY);
                        }
                        bl = true;
                        break;
                    }
                    if (d4 != this.m_intervalBounds[i][n2]) continue;
                    for (n3 = 0; n3 < this.m_NumClasses; ++n3) {
                        if (!(this.m_globalCounts[n3] > 0.0)) continue;
                        dArray2[n3] = (this.m_counts[i][n2][n3] + this.m_counts[i][n2 - 1][n3]) / 2.0 + this.TINY;
                        int n4 = n3;
                        dArray2[n4] = dArray2[n4] / (this.m_globalCounts[n3] + this.TINY);
                    }
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new Exception("This shouldn't happen");
                }
            } else {
                bl = true;
                for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                    if (!(this.m_globalCounts[n2] > 0.0)) continue;
                    dArray2[n2] = (this.m_counts[i][(int)d4][n2] + this.TINY) / (this.m_globalCounts[n2] + this.TINY);
                }
            }
            if ((d3 = Utils.sum(dArray2)) <= 0.0) {
                for (n = 0; n < dArray2.length; ++n) {
                    dArray2[n] = 1.0 / (double)dArray2.length;
                }
            } else {
                Utils.normalize(dArray2, d3);
            }
            if (this.m_weightByConfidence) {
                d2 = ContingencyTables.entropy(dArray2);
                if ((d2 = Math.pow(d2, this.m_bias)) < 1.0) {
                    d2 = 1.0;
                }
            }
            for (n = 0; n < this.m_NumClasses; ++n) {
                int n5 = n;
                dArray[n5] = dArray[n5] + dArray2[n] * d2;
            }
        }
        double d5 = Utils.sum(dArray);
        if (d5 <= 0.0) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 1.0 / (double)dArray.length;
            }
            return dArray;
        }
        Utils.normalize(dArray, d5);
        return dArray;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new VFI(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

