/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.fixed;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.SearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class FromFile
extends SearchAlgorithm {
    String m_sBIFFile = "";

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        BIFReader bIFReader = new BIFReader();
        bIFReader.processFile(this.m_sBIFFile);
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n = bIFReader.getNode(bayesNet.getNodeName(i));
            ParentSet parentSet = bIFReader.getParentSet(n);
            for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                int n2;
                String string = bIFReader.getNodeName(parentSet.getParent(j));
                for (n2 = 0; n2 < instances.numAttributes() && !bayesNet.getNodeName(n2).equals(string); ++n2) {
                }
                if (n2 >= instances.numAttributes()) {
                    throw new Exception("Could not find attribute " + string + " from BIF file in data");
                }
                bayesNet.getParentSet(i).addParent(n2, instances);
            }
        }
    }

    public void setBIFFile(String string) {
        this.m_sBIFFile = string;
    }

    public String getBIFFile() {
        return this.m_sBIFFile;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tName of file containing network structure in BIF format\n", "B", 1, "-B <BIF File>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setBIFFile(Utils.getOption('B', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[2 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-B";
        stringArray2[n++] = "" + this.getBIFFile();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }
}

