/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode1;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.VisualizePanelEvent;
import weka.gui.visualize.VisualizePanelListener;

public class UserClassifier
extends Classifier
implements Drawable,
TreeDisplayListener,
VisualizePanelListener,
TechnicalInformationHandler {
    static final long serialVersionUID = 6483901103562809843L;
    private static final int LEAF = 0;
    private static final int RECTANGLE = 1;
    private static final int POLYGON = 2;
    private static final int POLYLINE = 3;
    private static final int VLINE = 5;
    private static final int HLINE = 6;
    private transient TreeVisualizer m_tView = null;
    private transient VisualizePanel m_iView = null;
    private TreeClass m_top = null;
    private TreeClass m_focus;
    private int m_nextId = 0;
    private transient JTabbedPane m_reps;
    private transient JFrame m_mainWin;
    private boolean m_built = false;
    private GenericObjectEditor m_classifiers;
    private PropertyDialog m_propertyDialog;

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new UserClassifier(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public String toString() {
        if (!this.m_built) {
            return "Tree Not Built";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.m_top.toString(0, stringBuffer);
            this.m_top.objectStrings(stringBuffer);
        }
        catch (Exception exception) {
            System.out.println("error: " + exception.getMessage());
        }
        return stringBuffer.toString();
    }

    public void userCommand(TreeDisplayEvent treeDisplayEvent) {
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        try {
            if (this.m_iView == null || this.m_tView == null) {
                // empty if block
            }
            if (treeDisplayEvent.getCommand() != 0) {
                int n;
                if (treeDisplayEvent.getCommand() == 1) {
                    if (this.m_top == null) {
                        System.out.println("Error : Received event from a TreeDisplayer that is unknown to the classifier.");
                    } else {
                        this.m_tView.setHighlight(treeDisplayEvent.getID());
                        this.m_focus = this.m_top.getNode(treeDisplayEvent.getID());
                        this.m_iView.setInstances(this.m_focus.m_training);
                        if (this.m_focus.m_attrib1 >= 0) {
                            this.m_iView.setXIndex(this.m_focus.m_attrib1);
                        }
                        if (this.m_focus.m_attrib2 >= 0) {
                            this.m_iView.setYIndex(this.m_focus.m_attrib2);
                        }
                        this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                        if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                            this.m_iView.setShapes(this.m_focus.m_ranges);
                        }
                    }
                } else if (treeDisplayEvent.getCommand() == 2) {
                    this.m_focus = this.m_top.getNode(treeDisplayEvent.getID());
                    this.m_iView.setInstances(this.m_focus.m_training);
                    if (this.m_focus.m_attrib1 >= 0) {
                        this.m_iView.setXIndex(this.m_focus.m_attrib1);
                    }
                    if (this.m_focus.m_attrib2 >= 0) {
                        this.m_iView.setYIndex(this.m_focus.m_attrib2);
                    }
                    this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                    if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                        this.m_iView.setShapes(this.m_focus.m_ranges);
                    }
                    this.m_focus.m_set1 = null;
                    this.m_focus.m_set2 = null;
                    this.m_focus.setInfo(this.m_focus.m_attrib1, this.m_focus.m_attrib2, null);
                    this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode2());
                    this.m_reps.setComponentAt(0, this.m_tView);
                    this.m_tView.setHighlight(this.m_focus.m_identity);
                } else if (treeDisplayEvent.getCommand() == 4) {
                    this.m_focus = this.m_top.getNode(treeDisplayEvent.getID());
                    this.m_iView.setInstances(this.m_focus.m_training);
                    if (this.m_focus.m_attrib1 >= 0) {
                        this.m_iView.setXIndex(this.m_focus.m_attrib1);
                    }
                    if (this.m_focus.m_attrib2 >= 0) {
                        this.m_iView.setYIndex(this.m_focus.m_attrib2);
                    }
                    this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                    if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                        this.m_iView.setShapes(this.m_focus.m_ranges);
                    }
                    this.m_propertyDialog = new PropertyDialog(this.m_classifiers, this.m_mainWin.getLocationOnScreen().x, this.m_mainWin.getLocationOnScreen().y);
                    this.m_tView.setHighlight(this.m_focus.m_identity);
                } else if (treeDisplayEvent.getCommand() == 3 && (n = JOptionPane.showConfirmDialog(this.m_mainWin, "Are You Sure...\nClick Yes To Accept The Tree\n Click No To Return", "Accept Tree", 0)) == 0) {
                    this.m_mainWin.setDefaultCloseOperation(2);
                    this.m_mainWin.dispose();
                    this.blocker(false);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error : " + exception);
            System.out.println("Part of user input so had to catch here");
            exception.printStackTrace();
        }
    }

    public void userDataEvent(VisualizePanelEvent visualizePanelEvent) {
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        try {
            if (this.m_focus != null) {
                double d = visualizePanelEvent.getInstances1().numInstances() + visualizePanelEvent.getInstances2().numInstances();
                if (d == 0.0) {
                    d = 1.0;
                }
                TreeClass treeClass = this.m_focus;
                this.m_focus.m_set1 = new TreeClass(null, visualizePanelEvent.getAttribute1(), visualizePanelEvent.getAttribute2(), this.m_nextId, (double)visualizePanelEvent.getInstances1().numInstances() / d, visualizePanelEvent.getInstances1(), this.m_focus);
                this.m_focus.m_set2 = new TreeClass(null, visualizePanelEvent.getAttribute1(), visualizePanelEvent.getAttribute2(), this.m_nextId, (double)visualizePanelEvent.getInstances2().numInstances() / d, visualizePanelEvent.getInstances2(), this.m_focus);
                this.m_focus.setInfo(visualizePanelEvent.getAttribute1(), visualizePanelEvent.getAttribute2(), visualizePanelEvent.getValues());
                this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode2());
                this.m_reps.setComponentAt(0, this.m_tView);
                this.m_focus = this.m_focus.m_set2;
                this.m_tView.setHighlight(this.m_focus.m_identity);
                this.m_iView.setInstances(this.m_focus.m_training);
                if (treeClass.m_attrib1 >= 0) {
                    this.m_iView.setXIndex(treeClass.m_attrib1);
                }
                if (treeClass.m_attrib2 >= 0) {
                    this.m_iView.setYIndex(treeClass.m_attrib2);
                }
                this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                    this.m_iView.setShapes(this.m_focus.m_ranges);
                }
            } else {
                System.out.println("Somehow the focus is null");
            }
        }
        catch (Exception exception) {
            System.out.println("Error : " + exception);
            System.out.println("Part of user input so had to catch here");
        }
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph UserClassifierTree {\nnode [fontsize=10]\nedge [fontsize=10 style=bold]\n");
        this.m_top.toDotty(stringBuffer);
        return stringBuffer.toString() + "}\n";
    }

    private synchronized void blocker(boolean bl) {
        if (bl) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public String globalInfo() {
        return "Interactively classify through visual means. You are Presented with a scatter graph of the data against two user selectable attributes, as well as a view of the decision tree. You can create binary splits by creating polygons around data plotted on the scatter graph, as well as by allowing another classifier to take over at points in the decision tree should you see fit.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Malcolm Ware and Eibe Frank and Geoffrey Holmes and Mark Hall and Ian H. Witten");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Interactive machine learning: letting users build classifiers");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Int. J. Hum.-Comput. Stud.");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "55");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "3");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "281-292");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://www.cs.waikato.ac.nz/~ml/publications/2000/00MW-etal-Interactive-ML.ps");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_classifiers = new GenericObjectEditor(true);
        this.m_classifiers.setClassType(Classifier.class);
        this.m_classifiers.setValue(new ZeroR());
        ((GenericObjectEditor.GOEPanel)this.m_classifiers.getCustomEditor()).addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((UserClassifier)UserClassifier.this).m_focus.m_set1 = null;
                    ((UserClassifier)UserClassifier.this).m_focus.m_set2 = null;
                    UserClassifier.this.m_focus.setInfo(((UserClassifier)UserClassifier.this).m_focus.m_attrib1, ((UserClassifier)UserClassifier.this).m_focus.m_attrib2, null);
                    UserClassifier.this.m_focus.setClassifier((Classifier)UserClassifier.this.m_classifiers.getValue());
                    UserClassifier.this.m_classifiers = new GenericObjectEditor();
                    UserClassifier.this.m_classifiers.setClassType(Classifier.class);
                    UserClassifier.this.m_classifiers.setValue(new ZeroR());
                    ((GenericObjectEditor.GOEPanel)UserClassifier.this.m_classifiers.getCustomEditor()).addOkListener(this);
                    UserClassifier.this.m_tView = new TreeVisualizer((TreeDisplayListener)UserClassifier.this, UserClassifier.this.graph(), (NodePlace)new PlaceNode2());
                    UserClassifier.this.m_tView.setHighlight(((UserClassifier)UserClassifier.this).m_focus.m_identity);
                    UserClassifier.this.m_reps.setComponentAt(0, UserClassifier.this.m_tView);
                    UserClassifier.this.m_iView.setShapes(null);
                }
                catch (Exception exception) {
                    System.out.println("Error : " + exception);
                    System.out.println("Part of user input so had to catch here");
                }
            }
        });
        this.m_built = false;
        this.m_mainWin = new JFrame();
        this.m_mainWin.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(UserClassifier.this.m_mainWin, "Are You Sure...\nClick Yes To Accept The Tree\n Click No To Return", "Accept Tree", 0);
                if (n == 0) {
                    UserClassifier.this.m_mainWin.setDefaultCloseOperation(2);
                    UserClassifier.this.blocker(false);
                } else {
                    UserClassifier.this.m_mainWin.setDefaultCloseOperation(0);
                }
            }
        });
        this.m_reps = new JTabbedPane();
        this.m_mainWin.getContentPane().add(this.m_reps);
        Instances instances2 = new Instances(instances, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            instances2.add(instances.instance(i));
        }
        instances2.deleteWithMissingClass();
        this.m_focus = this.m_top = new TreeClass(null, 0, 0, this.m_nextId, 1.0, instances2, null);
        this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode1());
        this.m_reps.add("Tree Visualizer", this.m_tView);
        this.m_tView.setHighlight(this.m_top.m_identity);
        this.m_iView = new VisualizePanel(this);
        this.m_iView.setInstances(this.m_top.m_training);
        this.m_iView.setColourIndex(instances2.classIndex());
        this.m_reps.add("Data Visualizer", this.m_iView);
        this.m_mainWin.setSize(560, 420);
        this.m_mainWin.setVisible(true);
        this.blocker(true);
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        this.m_classifiers = null;
        this.m_built = true;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (!this.m_built) {
            return null;
        }
        double[] dArray = this.m_top.calcClassType(instance);
        if (this.m_top.m_training.classAttribute().isNumeric()) {
            return dArray;
        }
        double d = 0.0;
        double d2 = -1.0;
        double d3 = 0.0;
        for (n = 0; n < this.m_top.m_training.numClasses(); ++n) {
            d3 += dArray[n];
            if (!(dArray[n] > d2)) continue;
            d = n;
            d2 = dArray[n];
        }
        if (d3 <= 0.0) {
            return null;
        }
        for (n = 0; n < this.m_top.m_training.numClasses(); ++n) {
            dArray[n] = dArray[n] / d3;
        }
        return dArray;
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    private class TreeClass
    implements Serializable {
        static final long serialVersionUID = 595663560871347434L;
        public FastVector m_ranges;
        public int m_attrib1;
        public int m_attrib2;
        public TreeClass m_set1 = null;
        public TreeClass m_set2 = null;
        public TreeClass m_parent;
        public String m_identity;
        public double m_weight;
        public Instances m_training;
        public Classifier m_classObject;
        public Filter m_filter;

        public TreeClass(FastVector fastVector, int n, int n2, int n3, double d, Instances instances, TreeClass treeClass) throws Exception {
            this.m_ranges = fastVector;
            this.m_classObject = null;
            this.m_filter = null;
            this.m_training = instances;
            this.m_attrib1 = n;
            this.m_attrib2 = n2;
            this.m_identity = "N" + String.valueOf(n3);
            this.m_weight = d;
            this.m_parent = treeClass;
            UserClassifier.this.m_nextId++;
            if (this.m_ranges == null) {
                this.setLeaf();
            }
        }

        public void setClassifier(Classifier classifier) throws Exception {
            this.m_classObject = classifier;
            this.m_classObject.buildClassifier(this.m_training);
        }

        public void setInfo(int n, int n2, FastVector fastVector) throws Exception {
            this.m_classObject = null;
            this.m_filter = null;
            this.m_attrib1 = n;
            this.m_attrib2 = n2;
            this.m_ranges = fastVector;
            if (this.m_ranges == null) {
                this.setLeaf();
            }
        }

        private void setLeaf() throws Exception {
            if (this.m_training != null) {
                if (this.m_training.classAttribute().isNominal()) {
                    int n;
                    this.m_ranges = new FastVector(1);
                    this.m_ranges.addElement(new FastVector(this.m_training.numClasses() + 1));
                    FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
                    fastVector.addElement(new Double(0.0));
                    for (n = 0; n < this.m_training.numClasses(); ++n) {
                        fastVector.addElement(new Double(0.0));
                    }
                    for (n = 0; n < this.m_training.numInstances(); ++n) {
                        fastVector.setElementAt(new Double((Double)fastVector.elementAt((int)this.m_training.instance(n).classValue() + 1) + this.m_training.instance(n).weight()), (int)this.m_training.instance(n).classValue() + 1);
                    }
                } else {
                    this.m_ranges = new FastVector(1);
                    double d = 0.0;
                    for (int i = 0; i < this.m_training.numInstances(); ++i) {
                        d += this.m_training.instance(i).classValue();
                    }
                    if (this.m_training.numInstances() != 0) {
                        d /= (double)this.m_training.numInstances();
                    }
                    double d2 = 0.0;
                    for (int i = 0; i < this.m_training.numInstances(); ++i) {
                        d2 += Math.pow(this.m_training.instance(i).classValue() - d, 2.0);
                    }
                    if (this.m_training.numInstances() != 0) {
                        d = Math.sqrt(d2 / (double)this.m_training.numInstances());
                        this.m_ranges.addElement(new FastVector(2));
                        FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
                        fastVector.addElement(new Double(0.0));
                        fastVector.addElement(new Double(d));
                    } else {
                        this.m_ranges.addElement(new FastVector(2));
                        FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
                        fastVector.addElement(new Double(0.0));
                        fastVector.addElement(new Double(Double.NaN));
                    }
                }
            }
        }

        public double[] calcClassType(Instance instance) throws Exception {
            double d = 0.0;
            double d2 = 0.0;
            if (this.m_attrib1 >= 0) {
                d = instance.value(this.m_attrib1);
            }
            if (this.m_attrib2 >= 0) {
                d2 = instance.value(this.m_attrib2);
            }
            double[] dArray = this.m_training.classAttribute().isNominal() ? new double[this.m_training.numClasses()] : new double[1];
            if (this.m_classObject != null) {
                if (this.m_training.classAttribute().isNominal()) {
                    dArray[(int)this.m_classObject.classifyInstance((Instance)instance)] = 1.0;
                } else if (this.m_filter != null) {
                    this.m_filter.input(instance);
                    dArray[0] = this.m_classObject.classifyInstance(this.m_filter.output());
                } else {
                    dArray[0] = this.m_classObject.classifyInstance(instance);
                }
                return dArray;
            }
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                int n;
                if (this.m_training.classAttribute().isNumeric()) {
                    this.setLinear();
                    this.m_filter.input(instance);
                    dArray[0] = this.m_classObject.classifyInstance(this.m_filter.output());
                    return dArray;
                }
                int n2 = 0;
                FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
                for (n = 0; n < this.m_training.numClasses(); ++n) {
                    dArray[n] = (Double)fastVector.elementAt(n + 1);
                    n2 = (int)((double)n2 + dArray[n]);
                }
                for (n = 0; n < this.m_training.numClasses(); ++n) {
                    dArray[n] = dArray[n] / (double)n2;
                }
                return dArray;
            }
            for (int i = 0; i < this.m_ranges.size(); ++i) {
                FastVector fastVector = (FastVector)this.m_ranges.elementAt(i);
                if (((Double)fastVector.elementAt(0)).intValue() == 5 && !Instance.isMissingValue(d) || ((Double)fastVector.elementAt(0)).intValue() == 6 && !Instance.isMissingValue(d2)) continue;
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    dArray = this.m_set1.calcClassType(instance);
                    double[] dArray2 = this.m_set2.calcClassType(instance);
                    if (this.m_training.classAttribute().isNominal()) {
                        for (int j = 0; j < this.m_training.numClasses(); ++j) {
                            int n = j;
                            dArray[n] = dArray[n] * this.m_set1.m_weight;
                            int n3 = j;
                            dArray[n3] = dArray[n3] + dArray2[j] * this.m_set2.m_weight;
                        }
                    } else {
                        dArray[0] = dArray[0] * this.m_set1.m_weight;
                        dArray[0] = dArray[0] + dArray2[0] * this.m_set2.m_weight;
                    }
                    return dArray;
                }
                if (((Double)fastVector.elementAt(0)).intValue() == 1) {
                    if (!(d >= (Double)fastVector.elementAt(1)) || !(d <= (Double)fastVector.elementAt(3)) || !(d2 <= (Double)fastVector.elementAt(2)) || !(d2 >= (Double)fastVector.elementAt(4))) continue;
                    dArray = this.m_set1.calcClassType(instance);
                    return dArray;
                }
                if (((Double)fastVector.elementAt(0)).intValue() == 2) {
                    if (!this.inPoly(fastVector, d, d2)) continue;
                    dArray = this.m_set1.calcClassType(instance);
                    return dArray;
                }
                if (((Double)fastVector.elementAt(0)).intValue() != 3 || !this.inPolyline(fastVector, d, d2)) continue;
                dArray = this.m_set1.calcClassType(instance);
                return dArray;
            }
            if (this.m_set2 != null) {
                dArray = this.m_set2.calcClassType(instance);
            }
            return dArray;
        }

        private void setLinear() throws Exception {
            int n;
            boolean[] blArray = new boolean[this.m_training.numAttributes()];
            for (int i = 0; i < this.m_training.numAttributes(); ++i) {
                blArray[i] = false;
            }
            TreeClass treeClass = this;
            blArray[this.m_training.classIndex()] = true;
            while (treeClass != null) {
                blArray[treeClass.m_attrib1] = true;
                blArray[treeClass.m_attrib2] = true;
                treeClass = treeClass.m_parent;
            }
            int n2 = 0;
            for (n = 0; n < this.m_training.classIndex(); ++n) {
                if (!blArray[n]) continue;
                ++n2;
            }
            n = 0;
            for (int i = 0; i < this.m_training.numAttributes(); ++i) {
                if (!blArray[i]) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.m_training.numAttributes(); ++i) {
                if (!blArray[i]) continue;
                nArray[n] = i;
                ++n;
            }
            this.m_filter = new Remove();
            ((Remove)this.m_filter).setInvertSelection(true);
            ((Remove)this.m_filter).setAttributeIndicesArray(nArray);
            this.m_filter.setInputFormat(this.m_training);
            Instances instances = Filter.useFilter(this.m_training, this.m_filter);
            instances.setClassIndex(n2);
            this.m_classObject = new LinearRegression();
            this.m_classObject.buildClassifier(instances);
        }

        private boolean inPolyline(FastVector fastVector, double d, double d2) {
            double d3;
            double d4;
            int n = 0;
            for (int i = 1; i < fastVector.size() - 4; i += 2) {
                double d5;
                d4 = (Double)fastVector.elementAt(i + 1);
                d3 = (Double)fastVector.elementAt(i + 3);
                double d6 = (Double)fastVector.elementAt(i);
                double d7 = (Double)fastVector.elementAt(i + 2);
                double d8 = d3 - d4;
                double d9 = d7 - d6;
                if (i == 1 && i == fastVector.size() - 6) {
                    if (d8 == 0.0 || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (i == 1) {
                    if (!(d2 < d3 && d8 > 0.0) && (!(d2 > d3) || !(d8 < 0.0)) || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (i == fastVector.size() - 6) {
                    if (!(d2 <= d4 && d8 < 0.0) && (!(d2 >= d4) || !(d8 > 0.0)) || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (!(d4 <= d2 && d2 < d3) && (!(d3 < d2) || !(d2 <= d4)) || d8 == 0.0 || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                ++n;
            }
            d4 = (Double)fastVector.elementAt(fastVector.size() - 2);
            if (d4 > (d3 = ((Double)fastVector.elementAt(fastVector.size() - 1)).doubleValue())) {
                if (d4 >= d2 && d2 > d3) {
                    ++n;
                }
            } else if (d4 >= d2 || d2 > d3) {
                ++n;
            }
            return n % 2 == 1;
        }

        private boolean inPoly(FastVector fastVector, double d, double d2) {
            int n = 0;
            for (int i = 1; i < fastVector.size() - 2; i += 2) {
                double d3;
                double d4;
                double d5 = (Double)fastVector.elementAt(i + 1);
                double d6 = (Double)fastVector.elementAt(i + 3);
                if (!((d5 <= d2 && d2 < d6 || d6 < d2 && d2 <= d5) && (d4 = d6 - d5) != 0.0)) continue;
                double d7 = (Double)fastVector.elementAt(i);
                double d8 = (Double)fastVector.elementAt(i + 2);
                double d9 = d8 - d7;
                if (!(d9 * (d3 = (d2 - d5) / d4) + d7 >= d)) continue;
                ++n;
            }
            return n % 2 == 1;
        }

        public TreeClass getNode(String string) {
            TreeClass treeClass;
            if (string.equals(this.m_identity)) {
                return this;
            }
            if (this.m_set1 != null && (treeClass = this.m_set1.getNode(string)) != null) {
                return treeClass;
            }
            if (this.m_set2 != null && (treeClass = this.m_set2.getNode(string)) != null) {
                return treeClass;
            }
            return null;
        }

        public void getAlternateLabel(StringBuffer stringBuffer) throws Exception {
            FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
            if (this.m_classObject != null && this.m_training.classAttribute().isNominal()) {
                stringBuffer.append("Classified by " + this.m_classObject.getClass().getName());
            } else if (((Double)fastVector.elementAt(0)).intValue() == 0) {
                if (this.m_training.classAttribute().isNominal()) {
                    double d = -1000.0;
                    int n = 0;
                    double d2 = 0.0;
                    for (int i = 0; i < this.m_training.classAttribute().numValues(); ++i) {
                        if ((Double)fastVector.elementAt(i + 1) > d) {
                            d = (Double)fastVector.elementAt(i + 1);
                            n = i + 1;
                        }
                        d2 += ((Double)fastVector.elementAt(i + 1)).doubleValue();
                    }
                    stringBuffer.append(this.m_training.classAttribute().value(n - 1) + "(" + d2);
                    if (d2 > d) {
                        stringBuffer.append("/" + (d2 - d));
                    }
                    stringBuffer.append(")");
                } else {
                    if (this.m_classObject == null && ((Double)fastVector.elementAt(0)).intValue() == 0) {
                        this.setLinear();
                    }
                    stringBuffer.append("Standard Deviation = " + Utils.doubleToString((Double)fastVector.elementAt(1), 6));
                }
            } else {
                stringBuffer.append("Split on ");
                stringBuffer.append(this.m_training.attribute(this.m_attrib1).name() + " AND ");
                stringBuffer.append(this.m_training.attribute(this.m_attrib2).name());
            }
        }

        public void getLabel(StringBuffer stringBuffer) throws Exception {
            FastVector fastVector = (FastVector)this.m_ranges.elementAt(0);
            if (this.m_classObject != null && this.m_training.classAttribute().isNominal()) {
                stringBuffer.append("Classified by\\n" + this.m_classObject.getClass().getName());
            } else if (((Double)fastVector.elementAt(0)).intValue() == 0) {
                if (this.m_training.classAttribute().isNominal()) {
                    boolean bl = true;
                    for (int i = 0; i < this.m_training.classAttribute().numValues(); ++i) {
                        if (!((Double)fastVector.elementAt(i + 1) > 0.0)) continue;
                        if (bl) {
                            stringBuffer.append("[" + this.m_training.classAttribute().value(i));
                            bl = false;
                        } else {
                            stringBuffer.append("\\n[" + this.m_training.classAttribute().value(i));
                        }
                        stringBuffer.append(", " + (Double)fastVector.elementAt(i + 1) + "]");
                    }
                } else {
                    if (this.m_classObject == null && ((Double)fastVector.elementAt(0)).intValue() == 0) {
                        this.setLinear();
                    }
                    stringBuffer.append("Standard Deviation = " + Utils.doubleToString((Double)fastVector.elementAt(1), 6));
                }
            } else {
                stringBuffer.append("Split on\\n");
                stringBuffer.append(this.m_training.attribute(this.m_attrib1).name() + " AND\\n");
                stringBuffer.append(this.m_training.attribute(this.m_attrib2).name());
            }
        }

        public void toDotty(StringBuffer stringBuffer) throws Exception {
            stringBuffer.append(this.m_identity + " [label=\"");
            this.getLabel(stringBuffer);
            stringBuffer.append("\" ");
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                stringBuffer.append("shape=box ");
            } else {
                stringBuffer.append("shape=ellipse ");
            }
            stringBuffer.append("style=filled color=gray95]\n");
            if (this.m_set1 != null) {
                stringBuffer.append(this.m_identity + "->");
                stringBuffer.append(this.m_set1.m_identity + " [label=\"True\"]\n");
                this.m_set1.toDotty(stringBuffer);
            }
            if (this.m_set2 != null) {
                stringBuffer.append(this.m_identity + "->");
                stringBuffer.append(this.m_set2.m_identity + " [label=\"False\"]\n");
                this.m_set2.toDotty(stringBuffer);
            }
        }

        public void objectStrings(StringBuffer stringBuffer) {
            if (this.m_classObject != null) {
                stringBuffer.append("\n\n" + this.m_identity + " {\n" + this.m_classObject.toString() + "\n}");
            }
            if (this.m_set1 != null) {
                this.m_set1.objectStrings(stringBuffer);
            }
            if (this.m_set2 != null) {
                this.m_set2.objectStrings(stringBuffer);
            }
        }

        public void toString(int n, StringBuffer stringBuffer) throws Exception {
            int n2;
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                stringBuffer.append(": " + this.m_identity + " ");
                this.getAlternateLabel(stringBuffer);
            }
            if (this.m_set1 != null) {
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                this.getAlternateLabel(stringBuffer);
                stringBuffer.append(" (In Set)");
                this.m_set1.toString(n + 1, stringBuffer);
            }
            if (this.m_set2 != null) {
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                this.getAlternateLabel(stringBuffer);
                stringBuffer.append(" (Not in Set)");
                this.m_set2.toString(n + 1, stringBuffer);
            }
        }
    }
}

