/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.datagenerators.ClusterGenerator;

public class BIRCHCluster
extends ClusterGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = -334820527230755027L;
    protected int m_NumClusters;
    private int m_MinInstNum;
    private int m_MaxInstNum;
    private double m_MinRadius;
    private double m_MaxRadius;
    public static final int GRID = 0;
    public static final int SINE = 1;
    public static final int RANDOM = 2;
    public static final Tag[] TAGS_PATTERN = new Tag[]{new Tag(0, "Grid"), new Tag(1, "Sine"), new Tag(2, "Random")};
    private int m_Pattern;
    private double m_DistMult;
    private int m_NumCycles;
    public static final int ORDERED = 0;
    public static final int RANDOMIZED = 1;
    public static final Tag[] TAGS_INPUTORDER = new Tag[]{new Tag(0, "ordered"), new Tag(1, "randomized")};
    private int m_InputOrder;
    private double m_NoiseRate;
    private FastVector m_ClusterList;
    private int m_GridSize;
    private double m_GridWidth;

    public BIRCHCluster() {
        this.setNumClusters(this.defaultNumClusters());
        this.setMinInstNum(this.defaultMinInstNum());
        this.setMaxInstNum(this.defaultMaxInstNum());
        this.setMinRadius(this.defaultMinRadius());
        this.setMaxRadius(this.defaultMaxRadius());
        this.setPattern(this.defaultPattern());
        this.setDistMult(this.defaultDistMult());
        this.setNumCycles(this.defaultNumCycles());
        this.setInputOrder(this.defaultInputOrder());
        this.setNoiseRate(this.defaultNoiseRate());
    }

    public String globalInfo() {
        return "Cluster data generator designed for the BIRCH System\n\nDataset is generated with instances in K clusters.\nInstances are 2-d data points.\nEach cluster is characterized by the number of data points in itits radius and its center. The location of the cluster centers isdetermined by the pattern parameter. Three patterns are currentlysupported grid, sine and random.\n\nFor more information refer to:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Tian Zhang and Raghu Ramakrishnan and Miron Livny");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "BIRCH: An Efficient Data Clustering Method for Very Large Databases");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "ACM SIGMOD International Conference on Management of Data");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "103-114");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe number of clusters (default " + this.defaultNumClusters() + ")", "k", 1, "-k <num>"));
        vector.addElement(new Option("\tSet pattern to grid (default is random).\n\tThis flag cannot be used at the same time as flag I.\n\tThe pattern is random, if neither flag G nor flag I is set.", "G", 0, "-G"));
        vector.addElement(new Option("\tSet pattern to sine (default is random).\n\tThis flag cannot be used at the same time as flag I.\n\tThe pattern is random, if neither flag G nor flag I is set.", "I", 0, "-I"));
        vector.addElement(new Option("\tThe range of number of instances per cluster (default " + this.defaultMinInstNum() + ".." + this.defaultMaxInstNum() + ").\n" + "\tLower number must be between 0 and 2500,\n" + "\tupper number must be between 50 and 2500.", "N", 1, "-N <num>..<num>"));
        vector.addElement(new Option("\tThe range of radius per cluster (default " + this.defaultMinRadius() + ".." + this.defaultMaxRadius() + ").\n" + "\tLower number must be between 0 and SQRT(2), \n" + "\tupper number must be between SQRT(2) and SQRT(32).", "R", 1, "-R <num>..<num>"));
        vector.addElement(new Option("\tThe distance multiplier (default " + this.defaultDistMult() + ").", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tThe number of cycles (default " + this.defaultNumCycles() + ").", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tFlag for input order is ORDERED. If flag is not set then \n\tinput order is RANDOMIZED. RANDOMIZED is currently not \n\timplemented, therefore is the input order always ORDERED.", "O", 0, "-O"));
        vector.addElement(new Option("\tThe noise rate in percent (default " + this.defaultNoiseRate() + ").\n" + "\tCan be between 0% and 30%. (Remark: The original \n" + "\talgorithm only allows noise up to 10%.)", "P", 1, "-P <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('k', stringArray);
        if (string.length() != 0) {
            this.setNumClusters(Integer.parseInt(string));
        } else {
            this.setNumClusters(this.defaultNumClusters());
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setInstNums(string);
        } else {
            this.setInstNums(this.defaultMinInstNum() + ".." + this.defaultMaxInstNum());
        }
        string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setRadiuses(string);
        } else {
            this.setRadiuses(this.defaultMinRadius() + ".." + this.defaultMaxRadius());
        }
        boolean bl = Utils.getFlag('G', stringArray);
        boolean bl2 = Utils.getFlag('I', stringArray);
        if (bl && bl2) {
            throw new Exception("Flags -G and -I can only be set mutually exclusiv.");
        }
        this.setPattern(new SelectedTag(2, TAGS_PATTERN));
        if (bl) {
            this.setPattern(new SelectedTag(0, TAGS_PATTERN));
        }
        if (bl2) {
            this.setPattern(new SelectedTag(1, TAGS_PATTERN));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            if (!bl) {
                throw new Exception("Option M can only be used with GRID pattern.");
            }
            this.setDistMult(Double.parseDouble(string));
        } else {
            this.setDistMult(this.defaultDistMult());
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            if (!bl2) {
                throw new Exception("Option C can only be used with SINE pattern.");
            }
            this.setNumCycles(Integer.parseInt(string));
        } else {
            this.setNumCycles(this.defaultNumCycles());
        }
        if (Utils.getFlag('O', stringArray)) {
            this.setInputOrder(new SelectedTag(0, TAGS_INPUTORDER));
        } else {
            this.setInputOrder(this.defaultInputOrder());
        }
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setNoiseRate(Double.parseDouble(string));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-k");
        vector.add("" + this.getNumClusters());
        vector.add("-N");
        vector.add("" + this.getInstNums());
        vector.add("-R");
        vector.add("" + this.getRadiuses());
        if (this.m_Pattern == 0) {
            vector.add("-G");
            vector.add("-M");
            vector.add("" + this.getDistMult());
        }
        if (this.m_Pattern == 1) {
            vector.add("-I");
            vector.add("-C");
            vector.add("" + this.getNumCycles());
        }
        if (this.getOrderedFlag()) {
            vector.add("-O");
        }
        vector.add("-P");
        vector.add("" + this.getNoiseRate());
        return vector.toArray(new String[vector.size()]);
    }

    protected int defaultNumClusters() {
        return 4;
    }

    public void setNumClusters(int n) {
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String numClustersTipText() {
        return "The number of clusters to generate.";
    }

    protected void setInstNums(String string) {
        int n = string.indexOf("..");
        String string2 = string.substring(0, n);
        this.setMinInstNum(Integer.parseInt(string2));
        String string3 = string.substring(n + 2, string.length());
        this.setMaxInstNum(Integer.parseInt(string3));
    }

    protected String getInstNums() {
        String string = "" + this.getMinInstNum() + ".." + this.getMaxInstNum();
        return string;
    }

    protected String instNumsTipText() {
        return "The upper and lowet boundary for instances per cluster.";
    }

    protected int defaultMinInstNum() {
        return 1;
    }

    public int getMinInstNum() {
        return this.m_MinInstNum;
    }

    public void setMinInstNum(int n) {
        this.m_MinInstNum = n;
    }

    public String minInstNumTipText() {
        return "The lower boundary for instances per cluster.";
    }

    protected int defaultMaxInstNum() {
        return 50;
    }

    public int getMaxInstNum() {
        return this.m_MaxInstNum;
    }

    public void setMaxInstNum(int n) {
        this.m_MaxInstNum = n;
    }

    public String maxInstNumTipText() {
        return "The upper boundary for instances per cluster.";
    }

    protected void setRadiuses(String string) {
        int n = string.indexOf("..");
        String string2 = string.substring(0, n);
        this.setMinRadius(Double.valueOf(string2));
        String string3 = string.substring(n + 2, string.length());
        this.setMaxRadius(Double.valueOf(string3));
    }

    protected String getRadiuses() {
        String string = "" + Utils.doubleToString(this.getMinRadius(), 2) + ".." + Utils.doubleToString(this.getMaxRadius(), 2);
        return string;
    }

    protected String radiusesTipText() {
        return "The upper and lower boundary for the radius of the clusters.";
    }

    protected double defaultMinRadius() {
        return 0.1;
    }

    public double getMinRadius() {
        return this.m_MinRadius;
    }

    public void setMinRadius(double d) {
        this.m_MinRadius = d;
    }

    public String minRadiusTipText() {
        return "The lower boundary for the radius of the clusters.";
    }

    protected double defaultMaxRadius() {
        return Math.sqrt(2.0);
    }

    public double getMaxRadius() {
        return this.m_MaxRadius;
    }

    public void setMaxRadius(double d) {
        this.m_MaxRadius = d;
    }

    public String maxRadiusTipText() {
        return "The upper boundary for the radius of the clusters.";
    }

    protected SelectedTag defaultPattern() {
        return new SelectedTag(2, TAGS_PATTERN);
    }

    public SelectedTag getPattern() {
        return new SelectedTag(this.m_Pattern, TAGS_PATTERN);
    }

    public void setPattern(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PATTERN) {
            this.m_Pattern = selectedTag.getSelectedTag().getID();
        }
    }

    public String patternTipText() {
        return "The pattern for generating the data.";
    }

    protected double defaultDistMult() {
        return 4.0;
    }

    public double getDistMult() {
        return this.m_DistMult;
    }

    public void setDistMult(double d) {
        this.m_DistMult = d;
    }

    public String distMultTipText() {
        return "The distance multiplier (in combination with the 'Grid' pattern).";
    }

    protected int defaultNumCycles() {
        return 4;
    }

    public int getNumCycles() {
        return this.m_NumCycles;
    }

    public void setNumCycles(int n) {
        this.m_NumCycles = n;
    }

    public String numCyclesTipText() {
        return "The number of cycles to use (in combination with the 'Sine' pattern).";
    }

    protected SelectedTag defaultInputOrder() {
        return new SelectedTag(0, TAGS_INPUTORDER);
    }

    public SelectedTag getInputOrder() {
        return new SelectedTag(this.m_InputOrder, TAGS_INPUTORDER);
    }

    public void setInputOrder(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_INPUTORDER) {
            this.m_InputOrder = selectedTag.getSelectedTag().getID();
        }
    }

    public String inputOrderTipText() {
        return "The input order to use.";
    }

    public boolean getOrderedFlag() {
        return this.m_InputOrder == 0;
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double d) {
        this.m_NoiseRate = d;
    }

    public String noiseRateTipText() {
        return "The noise rate to use.";
    }

    public boolean getSingleModeFlag() {
        return false;
    }

    public Instances defineDataFormat() throws Exception {
        Attribute attribute;
        int n;
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        FastVector fastVector = new FastVector(3);
        boolean bl = this.getClassFlag();
        FastVector fastVector2 = null;
        if (bl) {
            fastVector2 = new FastVector(this.m_NumClusters);
        }
        for (n = 0; n < this.getNumAttributes(); ++n) {
            attribute = new Attribute("X" + n);
            fastVector.addElement(attribute);
        }
        if (bl) {
            for (n = 0; n < this.m_NumClusters; ++n) {
                fastVector2.addElement("c" + n);
            }
            attribute = new Attribute("class", fastVector2);
            fastVector.addElement(attribute);
        }
        Instances instances = new Instances(this.getRelationNameToUse(), fastVector, 0);
        if (bl) {
            instances.setClassIndex(this.getNumAttributes());
        }
        Instances instances2 = new Instances(instances, 0);
        this.setDatasetFormat(instances2);
        this.m_ClusterList = this.defineClusters(random);
        return instances;
    }

    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        if (!this.getOrderedFlag()) {
            throw new Exception("RANDOMIZED is not yet implemented.");
        }
        instances = this.generateExamples(random, instances);
        return instances;
    }

    public Instances generateExamples(Random random, Instances instances) throws Exception {
        Instance instance = null;
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        int n = 0;
        Enumeration enumeration = this.m_ClusterList.elements();
        while (enumeration.hasMoreElements()) {
            Cluster cluster = (Cluster)enumeration.nextElement();
            double d = cluster.getStdDev();
            int n2 = cluster.getInstNum();
            double[] dArray = cluster.getCenter();
            String string = "c" + n;
            for (int i = 0; i < n2; ++i) {
                instance = this.generateInstance(instances, random, d, dArray, string);
                if (instance != null) {
                    instance.setDataset(instances);
                }
                instances.add(instance);
            }
            ++n;
        }
        return instances;
    }

    private Instance generateInstance(Instances instances, Random random, double d, double[] dArray, String string) {
        int n = this.getNumAttributes();
        if (this.getClassFlag()) {
            ++n;
        }
        Instance instance = new Instance(n);
        instance.setDataset(instances);
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            instance.setValue(i, random.nextGaussian() * d + dArray[i]);
        }
        if (this.getClassFlag()) {
            instance.setClassValue(string);
        }
        return instance;
    }

    private FastVector defineClusters(Random random) throws Exception {
        if (this.m_Pattern == 0) {
            return this.defineClustersGRID(random);
        }
        return this.defineClustersRANDOM(random);
    }

    private FastVector defineClustersGRID(Random random) throws Exception {
        FastVector fastVector = new FastVector(this.m_NumClusters);
        double d = this.m_MaxInstNum - this.m_MinInstNum;
        double d2 = this.m_MinInstNum;
        double d3 = this.m_MaxRadius - this.m_MinRadius;
        double d4 = Math.pow(this.m_NumClusters, 1.0 / (double)this.getNumAttributes());
        this.m_GridSize = d4 - (double)((int)d4) > 0.0 ? (int)(d4 + 1.0) : (int)d4;
        this.m_GridWidth = (this.m_MaxRadius + this.m_MinRadius) / 2.0 * this.m_DistMult;
        GridVector gridVector = new GridVector(this.getNumAttributes(), this.m_GridSize);
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int n = (int)(random.nextDouble() * d + d2);
            double d5 = random.nextDouble() * d3 + this.m_MinRadius;
            Cluster cluster = new Cluster(n, d5, gridVector.getGridVector(), this.m_GridWidth);
            fastVector.addElement(cluster);
            gridVector.addOne();
        }
        return fastVector;
    }

    private FastVector defineClustersRANDOM(Random random) throws Exception {
        FastVector fastVector = new FastVector(this.m_NumClusters);
        double d = this.m_MaxInstNum - this.m_MinInstNum;
        double d2 = this.m_MinInstNum;
        double d3 = this.m_MaxRadius - this.m_MinRadius;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int n = (int)(random.nextDouble() * d + d2);
            double d4 = random.nextDouble() * d3 + this.m_MinRadius;
            Cluster cluster = new Cluster(n, d4, random);
            fastVector.addElement(cluster);
        }
        return fastVector;
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String generateStart() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.m_ClusterList.elements();
        while (enumeration.hasMoreElements()) {
            Cluster cluster = (Cluster)enumeration.nextElement();
            stringBuffer.append("%\n");
            stringBuffer.append("% Cluster: c" + n2 + "\n");
            stringBuffer.append("% ----------------------------------------------\n");
            stringBuffer.append("% StandardDeviation: " + Utils.doubleToString(cluster.getStdDev(), 2) + "\n");
            stringBuffer.append("% Number of instances: " + cluster.getInstNum() + "\n");
            n += cluster.getInstNum();
            double[] dArray = cluster.getCenter();
            stringBuffer.append("% ");
            for (int i = 0; i < dArray.length - 1; ++i) {
                stringBuffer.append(Utils.doubleToString(dArray[i], 2) + ", ");
            }
            stringBuffer.append(Utils.doubleToString(dArray[dArray.length - 1], 2) + "\n");
            ++n2;
        }
        stringBuffer.append("%\n% ----------------------------------------------\n");
        stringBuffer.append("% Total number of instances: " + n + "\n");
        stringBuffer.append("%                            in " + n2 + " clusters\n");
        stringBuffer.append("% Pattern chosen           : ");
        if (this.m_Pattern == 0) {
            stringBuffer.append("GRID, distance multiplier = " + Utils.doubleToString(this.m_DistMult, 2) + "\n");
        } else if (this.m_Pattern == 1) {
            stringBuffer.append("SINE\n");
        } else {
            stringBuffer.append("RANDOM\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        BIRCHCluster.runDataGenerator(new BIRCHCluster(), stringArray);
    }

    private class GridVector
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -1900309948991039522L;
        private int[] m_GridVector;
        private int m_Base;
        private int m_Size;

        private GridVector(int n, int n2) {
            this.m_Size = n;
            this.m_Base = n2;
            this.m_GridVector = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_GridVector[i] = 0;
            }
        }

        private int[] getGridVector() {
            return this.m_GridVector;
        }

        private boolean overflow(int n) {
            return n == 0;
        }

        private int addOne(int n) {
            int n2 = n + 1;
            if (n2 >= this.m_Base) {
                n2 = 0;
            }
            return n2;
        }

        private void addOne() {
            this.m_GridVector[0] = this.addOne(this.m_GridVector[0]);
            for (int i = 1; this.overflow(this.m_GridVector[i - 1]) && i < this.m_Size; ++i) {
                this.m_GridVector[i] = this.addOne(this.m_GridVector[i]);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.8 $");
        }
    }

    private class Cluster
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -8336901069823498140L;
        private int m_InstNum;
        private double m_Radius;
        private double[] m_Center;

        private Cluster(int n, double d, Random random) {
            this.m_InstNum = n;
            this.m_Radius = d;
            this.m_Center = new double[BIRCHCluster.this.getNumAttributes()];
            for (int i = 0; i < BIRCHCluster.this.getNumAttributes(); ++i) {
                this.m_Center[i] = random.nextDouble() * (double)BIRCHCluster.this.m_NumClusters;
            }
        }

        private Cluster(int n, double d, int[] nArray, double d2) {
            this.m_InstNum = n;
            this.m_Radius = d;
            this.m_Center = new double[BIRCHCluster.this.getNumAttributes()];
            for (int i = 0; i < BIRCHCluster.this.getNumAttributes(); ++i) {
                this.m_Center[i] = ((double)nArray[i] + 1.0) * d2;
            }
        }

        private int getInstNum() {
            return this.m_InstNum;
        }

        private double getRadius() {
            return this.m_Radius;
        }

        private double getVariance() {
            return Math.pow(this.m_Radius, 2.0) / 2.0;
        }

        private double getStdDev() {
            return this.m_Radius / Math.pow(2.0, 0.5);
        }

        private double[] getCenter() {
            return this.m_Center;
        }

        private double getCenterValue(int n) throws Exception {
            if (n >= this.m_Center.length) {
                throw new Exception("Current system has only " + this.m_Center.length + " dimensions.");
            }
            return this.m_Center[n];
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.8 $");
        }
    }
}

