/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.DoubleVector;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.PropositionalToMultiInstance;
import weka.filters.unsupervised.attribute.Standardize;

public class MIOptimalBall
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6465750129576777254L;
    protected double[] m_Center;
    protected double m_Radius;
    protected double[][][] m_Distance;
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected MultiInstanceToPropositional m_ConvertToSI = new MultiInstanceToPropositional();
    protected PropositionalToMultiInstance m_ConvertToMI = new PropositionalToMultiInstance();

    public String globalInfo() {
        return "This classifier tries to find a suitable ball in the multiple-instance space, with a certain data point in the instance space as a ball center. The possible ball center is a certain instance in a positive bag. The possible radiuses are those which can achieve the highest classification accuracy. The model selects the maximum radius as the radius of the optimal ball.\n\nFor more information about this algorithm, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Peter Auer and Ronald Ortner");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Boosting Approach to Multiple Instance Learning");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "15th European Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "63-74");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "LNAI 3201");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        int n = instances2.attribute(1).relation().numAttributes();
        this.m_Center = new double[n];
        if (this.getDebug()) {
            System.out.println("Start training ...");
        }
        this.m_ConvertToSI.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_ConvertToSI);
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_Filter);
        }
        this.m_ConvertToMI.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_ConvertToMI);
        this.calculateDistance(instances2);
        this.findRadius(instances2);
        if (this.getDebug()) {
            System.out.println("Finish building optimal ball model");
        }
    }

    public void calculateDistance(Instances instances) {
        int n = instances.numInstances();
        this.m_Distance = new double[n][][];
        for (int i = 0; i < n; ++i) {
            if (instances.instance(i).classValue() != 1.0) continue;
            int n2 = instances.instance(i).relationalValue(1).numInstances();
            this.m_Distance[i] = new double[n2][];
            for (int j = 0; j < n2; ++j) {
                Instance instance = instances.instance(i).relationalValue(1).instance(j);
                this.m_Distance[i][j] = new double[n];
                for (int k = 0; k < n; ++k) {
                    this.m_Distance[i][j][k] = i == k ? 0.0 : this.minBagDistance(instance, instances.instance(k));
                }
            }
        }
    }

    public double minBagDistance(Instance instance, Instance instance2) {
        double d = Double.MAX_VALUE;
        Instances instances = instance2.relationalValue(1);
        for (int i = 0; i < instances.numInstances(); ++i) {
            double d2 = 0.0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                d2 += (instance.value(j) - instances.instance(i).value(j)) * (instance.value(j) - instances.instance(i).value(j));
            }
            if (!(d > d2)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    public void findRadius(Instances instances) {
        int n = 0;
        int n2 = instances.numInstances();
        for (int i = 0; i < n2; ++i) {
            if (instances.instance(i).classValue() != 1.0) continue;
            int n3 = instances.instance(i).relationalValue(1).numInstances();
            for (int j = 0; j < n3; ++j) {
                Instance instance = instances.instance(i).relationalValue(1).instance(j);
                double[] dArray = this.sortArray(this.m_Distance[i][j]);
                for (int k = 1; k < dArray.length; ++k) {
                    int n4;
                    double d = dArray[k] - (dArray[k] - dArray[k - 1]) / 2.0;
                    int n5 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        double d2 = this.m_Distance[i][j][n4];
                        if (!(d2 <= d && instances.instance(n4).classValue() == 1.0) && (!(d2 > d) || instances.instance(n4).classValue() != 0.0)) continue;
                        n5 = (int)((double)n5 + instances.instance(n4).weight());
                    }
                    if (n5 <= n && (n5 != n || !(d > this.m_Radius))) continue;
                    n = n5;
                    this.m_Radius = d;
                    for (n4 = 0; n4 < instance.numAttributes(); ++n4) {
                        this.m_Center[n4] = instance.value(n4);
                    }
                }
            }
        }
    }

    public double[] sortArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i];
        }
        DoubleVector doubleVector = new DoubleVector(dArray3);
        doubleVector.sort();
        dArray2 = doubleVector.getArrayCopy();
        return dArray2;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[]{0.0, 0.0};
        Instances instances = new Instances(instance.dataset(), 0);
        instances.add(instance);
        instances = Filter.useFilter(instances, this.m_ConvertToSI);
        if (this.m_Filter != null) {
            instances = Filter.useFilter(instances, this.m_Filter);
        }
        int n = instances.numInstances();
        instances.deleteAttributeAt(0);
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < instances.numAttributes() - 1; ++j) {
                d += (instances.instance(i).value(j) - this.m_Center[j]) * (instances.instance(i).value(j) - this.m_Center[j]);
            }
            if (!(d <= this.m_Radius * this.m_Radius)) continue;
            dArray[1] = 1.0;
            break;
        }
        dArray[0] = 1.0 - dArray[1];
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. \n\t(default 0=normalize)", "N", 1, "-N <num>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        vector.add("-N");
        vector.add("" + this.m_filterType);
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        MIOptimalBall.runClassifier(new MIOptimalBall(), stringArray);
    }
}

