/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.misc.monotone.Coordinates;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.classifiers.misc.monotone.EnumerationIterator;
import weka.classifiers.misc.monotone.InstancesComparator;
import weka.classifiers.misc.monotone.InstancesUtil;
import weka.classifiers.misc.monotone.MultiDimensionalSort;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class OLM
extends RandomizableClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 3722951802290935192L;
    public static final int CT_ROUNDED = 0;
    public static final int CT_REAL = 1;
    public static final Tag[] TAGS_CLASSIFICATIONTYPES = new Tag[]{new Tag(0, "CL", "Round to nearest label"), new Tag(1, "REG", "Regression-like classification")};
    public static final int AT_MEAN = 0;
    public static final int AT_MEDIAN = 1;
    public static final int AT_MAXPROB = 2;
    public static final Tag[] TAGS_AVERAGINGTYPES = new Tag[]{new Tag(0, "MEAN", "Mean"), new Tag(1, "MED", "Median"), new Tag(2, "MAX", "Max probability")};
    public static final int DT_NONE = -1;
    public static final int DT_EUCLID = 0;
    public static final int DT_HAMMING = 1;
    public static final Tag[] TAGS_DISTANCETYPES = new Tag[]{new Tag(-1, "NONE", "No nearest neighbor"), new Tag(0, "EUCL", "Euclidean"), new Tag(1, "HAM", "Hamming")};
    public static final int ET_MIN = 0;
    public static final int ET_MAX = 1;
    public static final int ET_BOTH = 2;
    public static final Tag[] TAGS_EXTENSIONTYPES = new Tag[]{new Tag(0, "MIN", "Minimal extension"), new Tag(1, "MAX", "Maximal extension"), new Tag(2, "BOTH", "Minimal and maximal extension")};
    private Instances m_train;
    private int m_numClasses;
    private Instances m_baseMin;
    private Instances m_baseMax;
    private Map m_estimatedDistributions;
    private int m_ctype = 1;
    private int m_atype = 0;
    private int m_dtype = 0;
    private int m_etype = 0;
    private boolean m_sort = false;

    public String globalInfo() {
        return "This class is an implementation of the Ordinal Learning Method\nFurther information regarding the algorithm and variants can be found in:\n\n" + this.getTechnicalInformation().toString();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Arie Ben-David");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1992");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Automatic Generation of Symbolic Multiattribute Ordinal Knowledge-Based DSSs: methodology and Applications");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Decision Sciences");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "1357-1372");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "23");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Lievens, Stijn");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2003-2004");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Studie en implementatie van instantie-gebaseerde algoritmen voor gesuperviseerd rangschikken.");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        return technicalInformation;
    }

    public String classificationTypeTipText() {
        return "Sets the classification type.";
    }

    public void setClassificationType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_CLASSIFICATIONTYPES) {
            this.m_ctype = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getClassificationType() {
        return new SelectedTag(this.m_ctype, TAGS_CLASSIFICATIONTYPES);
    }

    public String averagingTypeTipText() {
        return "Choses the way in which the distributions are averaged in the first phase of the algorithm.";
    }

    public void setAveragingType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_AVERAGINGTYPES) {
            this.m_atype = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAveragingType() {
        return new SelectedTag(this.m_atype, TAGS_AVERAGINGTYPES);
    }

    public String distanceTypeTipText() {
        return "Sets the distance that is to be used by the nearest neighbour rule";
    }

    public void setDistanceType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_DISTANCETYPES) {
            this.m_dtype = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getDistanceType() {
        return new SelectedTag(this.m_dtype, TAGS_DISTANCETYPES);
    }

    public String extensionTypeTipText() {
        return "Sets the extension type to use.";
    }

    public void setExtensionType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_EXTENSIONTYPES) {
            this.m_etype = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getExtensionType() {
        return new SelectedTag(this.m_etype, TAGS_EXTENSIONTYPES);
    }

    public String sortTipText() {
        return "If true, the instances are also sorted within the classes prior to building the rule bases.";
    }

    public void setSort(boolean bl) {
        this.m_sort = bl;
    }

    public boolean getSort() {
        return this.m_sort;
    }

    public String seedTipText() {
        return "Sets the seed that is used to randomize the instances prior to building the rule bases";
    }

    public int getSizeRuleBaseMin() {
        return this.m_baseMin.numInstances();
    }

    public int getSizeRuleBaseMax() {
        return this.m_baseMax.numInstances();
    }

    public double classifyInstance(Instance instance) {
        double d;
        double d2 = -1.0;
        double d3 = -1.0;
        if (this.m_etype == 0 || this.m_etype == 2) {
            d2 = this.classifyInstanceMin(instance);
        }
        if (this.m_etype == 1 || this.m_etype == 2) {
            d3 = this.classifyInstanceMax(instance);
        }
        switch (this.m_etype) {
            case 0: {
                d = d2;
                break;
            }
            case 1: {
                d = d3;
                break;
            }
            case 2: {
                d = (d2 + d3) / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal mode type!");
            }
        }
        return this.m_ctype == 0 ? (double)Utils.round(d) : d;
    }

    private double classifyInstanceMin(Instance instance) {
        Instance[] instanceArray;
        double d = -1.0;
        if (this.m_baseMin == null) {
            throw new IllegalStateException("Classifier has not yet been built");
        }
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMin.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            instanceArray = (Instance[])enumerationIterator.next();
            if (!InstancesUtil.smallerOrEqual((Instance)instanceArray, instance)) continue;
            d = instanceArray.classValue();
            break;
        }
        if (d == -1.0) {
            if (this.m_dtype != -1) {
                instanceArray = this.nearestRules(instance, this.m_baseMin);
                d = 0.0;
                for (int i = 0; i < instanceArray.length; ++i) {
                    d += instanceArray[i].classValue();
                }
                d /= (double)instanceArray.length;
            } else {
                d = 0.0;
            }
        }
        return d;
    }

    private double classifyInstanceMax(Instance instance) {
        Instance[] instanceArray;
        double d = -1.0;
        if (this.m_baseMax == null) {
            throw new IllegalStateException("Classifier has not yet been built");
        }
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMax.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            instanceArray = (Instance[])enumerationIterator.next();
            if (!InstancesUtil.smallerOrEqual(instance, (Instance)instanceArray)) continue;
            d = instanceArray.classValue();
            break;
        }
        if (d == -1.0) {
            if (this.m_dtype != -1) {
                instanceArray = this.nearestRules(instance, this.m_baseMax);
                d = 0.0;
                for (int i = 0; i < instanceArray.length; ++i) {
                    d += instanceArray[i].classValue();
                }
                d /= (double)instanceArray.length;
            } else {
                d = this.m_numClasses - 1;
            }
        }
        return d;
    }

    private Instance[] nearestRules(Instance instance, Instances instances) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = 0.0;
        double[] dArray = InstancesUtil.toDataDouble(instance);
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            double[] dArray2 = InstancesUtil.toDataDouble(instance2);
            switch (this.m_dtype) {
                case 0: {
                    d2 = this.euclidDistance(dArray, dArray2);
                    break;
                }
                case 1: {
                    d2 = this.hammingDistance(dArray, dArray2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("distance type is not valid");
                }
            }
            if (d2 < d) {
                d = d2;
                arrayList.clear();
                arrayList.add(instance2);
                continue;
            }
            if (d2 != d) continue;
            arrayList.add(instance2);
        }
        arrayList.trimToSize();
        return arrayList.toArray(new Instance[0]);
    }

    public void buildClassifier(Instances instances) throws Exception {
        RevisionHandler revisionHandler;
        RevisionHandler revisionHandler2;
        Copyable copyable;
        this.getCapabilities().testWithFail(instances);
        this.m_train = new Instances(instances);
        this.m_numClasses = this.m_train.numClasses();
        this.m_train.deleteWithMissingClass();
        this.m_estimatedDistributions = new HashMap(this.m_train.numInstances() / 2);
        Iterator iterator = new EnumerationIterator(this.m_train.enumerateInstances());
        while (iterator.hasNext()) {
            copyable = (Instance)iterator.next();
            revisionHandler2 = new Coordinates((Instance)copyable);
            DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(revisionHandler2);
            if (discreteEstimator == null) {
                discreteEstimator = new DiscreteEstimator(instances.numClasses(), 0.0);
            }
            discreteEstimator.addValue(((Instance)copyable).classValue(), ((Instance)copyable).weight());
            this.m_estimatedDistributions.put(revisionHandler2, discreteEstimator);
        }
        copyable = new FastVector(this.m_train.numAttributes());
        revisionHandler2 = null;
        for (int i = 0; i < this.m_train.numAttributes(); ++i) {
            revisionHandler = this.m_train.attribute(i);
            if (i != this.m_train.classIndex()) {
                ((FastVector)copyable).addElement(((Attribute)revisionHandler).copy());
                continue;
            }
            revisionHandler2 = new Attribute(((Attribute)revisionHandler).name());
        }
        ((FastVector)copyable).addElement(revisionHandler2);
        this.m_train = new Instances(this.m_train.relationName(), (FastVector)copyable, this.m_estimatedDistributions.size());
        this.m_train.setClassIndex(this.m_train.numAttributes() - 1);
        iterator = this.m_estimatedDistributions.keySet().iterator();
        while (iterator.hasNext()) {
            double[] dArray = new double[this.m_train.numAttributes()];
            revisionHandler = (Coordinates)iterator.next();
            DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(revisionHandler);
            ((Coordinates)revisionHandler).getValues(dArray);
            switch (this.m_atype) {
                case 0: {
                    dArray[dArray.length - 1] = new DiscreteDistribution(discreteEstimator).mean();
                    break;
                }
                case 1: {
                    dArray[dArray.length - 1] = new DiscreteDistribution(discreteEstimator).median();
                    break;
                }
                case 2: {
                    dArray[dArray.length - 1] = new DiscreteDistribution(discreteEstimator).modes()[0];
                    break;
                }
                default: {
                    throw new IllegalStateException("Not a valid averaging type");
                }
            }
            this.m_train.add(new Instance(1.0, dArray));
        }
        if (this.m_Debug) {
            System.out.println("The dataset after phase 1 :");
            System.out.println(this.m_train.toString());
        }
        this.m_train.randomize(new Random(this.getSeed()));
        if (!this.m_sort) {
            this.m_train.sort(this.m_train.classIndex());
        } else {
            int n;
            Comparator[] comparatorArray = new Comparator[this.m_train.numAttributes()];
            comparatorArray[0] = new InstancesComparator(this.m_train.classIndex());
            for (int i = 1; i < comparatorArray.length; ++i) {
                comparatorArray[i] = new InstancesComparator(i - 1, true);
            }
            Object[] objectArray = new Instance[this.m_train.numInstances()];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = this.m_train.instance(n);
            }
            MultiDimensionalSort.multiDimensionalSort(objectArray, comparatorArray);
            this.m_train.delete();
            for (n = 0; n < objectArray.length; ++n) {
                this.m_train.add((Instance)objectArray[n]);
            }
        }
        this.m_baseMin = new Instances(this.m_train, this.m_estimatedDistributions.size() / 4);
        this.phaseTwoMin();
        this.m_baseMax = new Instances(this.m_train, this.m_estimatedDistributions.size() / 4);
        this.phaseTwoMax();
    }

    private void phaseTwoMin() {
        for (int i = this.m_train.numInstances() - 1; i >= 0; --i) {
            Instance instance = this.m_train.instance(i);
            if (this.isRedundant(instance)) continue;
            int[] nArray = this.makesRedundant(instance);
            if (nArray[0] == 1 && !this.causesReversedPreference(instance)) {
                this.m_baseMin.delete(nArray[1]);
                this.m_baseMin.add(instance);
                continue;
            }
            if (nArray[0] != 0) continue;
            int[] nArray2 = this.reversedPreferences(instance);
            if (nArray2[0] == 1) {
                this.m_baseMin.delete(nArray2[1]);
                this.m_baseMin.add(instance);
                continue;
            }
            if (nArray2[0] != 0) continue;
            this.m_baseMin.add(instance);
        }
    }

    private void phaseTwoMax() {
        for (int i = 0; i < this.m_train.numInstances(); ++i) {
            Instance instance = this.m_train.instance(i);
            if (this.isRedundantMax(instance)) continue;
            int[] nArray = this.makesRedundantMax(instance);
            if (nArray[0] == 1 && !this.causesReversedPreferenceMax(instance)) {
                this.m_baseMax.delete(nArray[1]);
                this.m_baseMax.add(instance);
                continue;
            }
            if (nArray[0] != 0) continue;
            int[] nArray2 = this.reversedPreferencesMax(instance);
            if (nArray2[0] == 1) {
                this.m_baseMax.delete(nArray2[1]);
                this.m_baseMax.add(instance);
                continue;
            }
            if (nArray2[0] != 0) continue;
            this.m_baseMax.add(instance);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OLM\n===\n\n");
        if (this.m_etype == 0 || this.m_etype == 2) {
            if (this.m_baseMin != null) {
                stringBuffer.append("Number of examples in the minimal rule base = " + this.m_baseMin.numInstances() + "\n");
            } else {
                stringBuffer.append("minimal rule base not yet created");
            }
        }
        if (this.m_etype == 1 || this.m_etype == 2) {
            if (this.m_baseMax != null) {
                stringBuffer.append("Number of examples in the maximal rule base = " + this.m_baseMax.numInstances() + "\n");
            } else {
                stringBuffer.append("maximal rule base not yet created");
            }
        }
        if (this.m_Debug) {
            if (this.m_etype == 0 || this.m_etype == 2) {
                stringBuffer.append("The minimal rule base is \n");
                if (this.m_baseMin != null) {
                    stringBuffer.append(this.m_baseMin.toString());
                } else {
                    stringBuffer.append(".... not yet created");
                }
            }
            if (this.m_etype == 1 || this.m_etype == 2) {
                stringBuffer.append("The second rule base is \n");
                if (this.m_baseMax != null) {
                    stringBuffer.append(this.m_baseMax.toString());
                } else {
                    stringBuffer.append(".... not yet created");
                }
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private boolean isRedundant(Instance instance) {
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMin.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (instance.classValue() != instance2.classValue() || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            return true;
        }
        return false;
    }

    private boolean isRedundantMax(Instance instance) {
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMax.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (instance.classValue() != instance2.classValue() || !InstancesUtil.smallerOrEqual(instance, instance2)) continue;
            return true;
        }
        return false;
    }

    private int[] makesRedundant(Instance instance) {
        int[] nArray = new int[2];
        for (int i = 0; i < this.m_baseMin.numInstances(); ++i) {
            Instance instance2 = this.m_baseMin.instance(i);
            if (instance2.classValue() != instance.classValue() || !InstancesUtil.smallerOrEqual(instance, instance2)) continue;
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = i;
                continue;
            }
            nArray[0] = 2;
            return nArray;
        }
        return nArray;
    }

    private int[] makesRedundantMax(Instance instance) {
        int[] nArray = new int[2];
        for (int i = 0; i < this.m_baseMax.numInstances(); ++i) {
            Instance instance2 = this.m_baseMax.instance(i);
            if (instance2.classValue() != instance.classValue() || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = i;
                continue;
            }
            nArray[0] = 2;
            return nArray;
        }
        return nArray;
    }

    private boolean causesReversedPreference(Instance instance) {
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMin.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (instance.classValue() > instance2.classValue() && InstancesUtil.smallerOrEqual(instance, instance2)) {
                System.err.println("Should not happen in the original OLM algorithm");
                return true;
            }
            if (!(instance2.classValue() > instance.classValue()) || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            return true;
        }
        return false;
    }

    private boolean causesReversedPreferenceMax(Instance instance) {
        EnumerationIterator enumerationIterator = new EnumerationIterator(this.m_baseMax.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (instance.classValue() > instance2.classValue() && InstancesUtil.smallerOrEqual(instance, instance2)) {
                return true;
            }
            if (!(instance2.classValue() > instance.classValue()) || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            return true;
        }
        return false;
    }

    private int[] reversedPreferences(Instance instance) {
        int[] nArray = new int[2];
        for (int i = 0; i < this.m_baseMin.numInstances(); ++i) {
            Instance instance2 = this.m_baseMin.instance(i);
            if (!(instance.classValue() < instance2.classValue()) || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = i;
                continue;
            }
            nArray[0] = 2;
            return nArray;
        }
        return nArray;
    }

    private int[] reversedPreferencesMax(Instance instance) {
        int[] nArray = new int[2];
        for (int i = 0; i < this.m_baseMax.numInstances(); ++i) {
            Instance instance2 = this.m_baseMax.instance(i);
            if (!(instance.classValue() > instance2.classValue()) || !InstancesUtil.smallerOrEqual(instance, instance2)) continue;
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = i;
                continue;
            }
            nArray[0] = 2;
            return nArray;
        }
        return nArray;
    }

    private double euclidDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        return d;
    }

    private int hammingDistance(double[] dArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n += dArray[i] == dArray2[i] ? 0 : 1;
        }
        return n;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String string = "\tSets the classification type to be used.\n\t(Default: " + new SelectedTag(1, TAGS_CLASSIFICATIONTYPES) + ")";
        String string2 = "-C " + Tag.toOptionList(TAGS_CLASSIFICATIONTYPES);
        String string3 = "C";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tSets the averaging type used in phase 1 of the classifier.\n\t(Default: " + new SelectedTag(0, TAGS_AVERAGINGTYPES) + ")";
        string2 = "-A " + Tag.toOptionList(TAGS_AVERAGINGTYPES);
        string3 = "A";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tIf different from " + new SelectedTag(-1, TAGS_DISTANCETYPES) + ", a nearest neighbour rule is fired when the\n" + "\trule base doesn't contain an example smaller than the instance\n" + "\tto be classified\n" + "\t(Default: " + new SelectedTag(-1, TAGS_DISTANCETYPES) + ").";
        string2 = "-N " + Tag.toOptionList(TAGS_DISTANCETYPES);
        string3 = "N";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tSets the extension type, i.e. the rule base to use.\n\t(Default: " + new SelectedTag(0, TAGS_EXTENSIONTYPES) + ")";
        string2 = "-E " + Tag.toOptionList(TAGS_EXTENSIONTYPES);
        string3 = "E";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tIf set, the instances are also sorted within the same class\n\tbefore building the rule bases";
        string2 = "-sort";
        string3 = "sort";
        vector.addElement(new Option(string, string3, 0, string2));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setClassificationType(new SelectedTag(string, TAGS_CLASSIFICATIONTYPES));
        } else {
            this.setClassificationType(new SelectedTag(1, TAGS_CLASSIFICATIONTYPES));
        }
        string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            this.setAveragingType(new SelectedTag(string, TAGS_AVERAGINGTYPES));
        } else {
            this.setAveragingType(new SelectedTag(0, TAGS_AVERAGINGTYPES));
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setDistanceType(new SelectedTag(string, TAGS_DISTANCETYPES));
        } else {
            this.setDistanceType(new SelectedTag(-1, TAGS_DISTANCETYPES));
        }
        string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExtensionType(new SelectedTag(string, TAGS_EXTENSIONTYPES));
        } else {
            this.setExtensionType(new SelectedTag(0, TAGS_EXTENSIONTYPES));
        }
        this.setSort(Utils.getFlag("sort", stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add("" + this.getClassificationType());
        vector.add("-A");
        vector.add("" + this.getAveragingType());
        vector.add("-N");
        vector.add("" + this.getDistanceType());
        vector.add("-E");
        vector.add("" + this.getExtensionType());
        if (this.getSort()) {
            vector.add("-sort");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        OLM.runClassifier(new OLM(), stringArray);
    }
}

