/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class NumericToNominal
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6614630932899796239L;
    protected static final int MAX_DECIMALS = 6;
    protected Range m_Cols = new Range("first-last");
    protected String m_DefaultCols = "first-last";

    public String globalInfo() {
        return "A filter for turning numeric attributes into nominal ones. Unlike discretization, it just takes all numeric values and adds them to the list of nominal values of that attribute. Useful after CSV imports, to enforce certain attributes to become nominal, e.g., the class attribute, containing values from 1 to 5.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (!this.getAttributeIndices().equals("")) {
            vector.add("-R");
            vector.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            vector.add("-V");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be 'nominalized'; if true, only non-selected attributes will be 'nominalized'.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Cols.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_Cols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        this.m_Cols.setUpper(instances.numAttributes() - 1);
        Instances instances2 = new Instances(instances);
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            if (!this.m_Cols.isInRange(i) || !instances2.attribute(i).isNumeric()) {
                fastVector.addElement(instances2.attribute(i));
                continue;
            }
            boolean bl = instances2.attribute(i).type() == 3;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int j = 0; j < instances2.numInstances(); ++j) {
                Instance instance = instances2.instance(j);
                if (instance.isMissing(i)) continue;
                if (bl) {
                    hashSet.add(instance.stringValue(i));
                    continue;
                }
                hashSet.add(new Double(instance.value(i)));
            }
            Vector vector = new Vector();
            for (Object e : hashSet) {
                vector.add(e);
            }
            Collections.sort(vector);
            FastVector fastVector2 = new FastVector();
            for (Object e : vector) {
                if (bl) {
                    fastVector2.addElement(e.toString());
                    continue;
                }
                fastVector2.addElement(Utils.doubleToString((Double)e, 6));
            }
            fastVector.addElement(new Attribute(instances2.attribute(i).name(), fastVector2));
        }
        Instances instances3 = new Instances(instances.relationName(), fastVector, 0);
        instances3.setClassIndex(instances.classIndex());
        return instances3;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.setOutputFormat(this.determineOutputFormat(this.getInputFormat()));
        }
        Instances instances2 = new Instances(this.getOutputFormat());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double[] dArray = instance.toDoubleArray();
            for (int j = 0; j < dArray.length; ++j) {
                if (!this.m_Cols.isInRange(j) || !instances.attribute(j).isNumeric() || instance.isMissing(j)) continue;
                String string = instances.attribute(j).type() == 3 ? instance.stringValue(j) : Utils.doubleToString(instance.value(j), 6);
                dArray[j] = instances2.attribute(j).indexOfValue(string);
            }
            Instance instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
            instance2.setDataset(this.getOutputFormat());
            this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
            instances2.add(instance2);
        }
        return instances2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] stringArray) {
        NumericToNominal.runFilter(new NumericToNominal(), stringArray);
    }
}

